/*
 * Decompiled with CFR 0.152.
 */
package com.kpelykh.docker.client.test;

import com.kpelykh.docker.client.DockerClient;
import com.kpelykh.docker.client.DockerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITestResult;

public abstract class AbstractDockerClientTest
extends Assert {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDockerClientTest.class);
    protected DockerClient dockerClient;
    protected List<String> tmpImgs;
    protected List<String> tmpContainers;

    public void beforeTest() throws DockerException {
        LOG.info("======================= BEFORETEST =======================");
        String url = System.getProperty("docker.url", "http://localhost:4243");
        LOG.info("Connecting to Docker server at " + url);
        this.dockerClient = new DockerClient(url);
        LOG.info("Creating image 'busybox'");
        this.logResponseStream(this.dockerClient.pull("busybox"));
        AbstractDockerClientTest.assertNotNull((Object)this.dockerClient);
        LOG.info("======================= END OF BEFORETEST =======================\n\n");
    }

    public void afterTest() {
        LOG.info("======================= END OF AFTERTEST =======================");
    }

    public void beforeMethod(Method method) {
        this.tmpContainers = new ArrayList<String>();
        this.tmpImgs = new ArrayList<String>();
        LOG.info(String.format("################################## STARTING %s ##################################", method.getName()));
    }

    public void afterMethod(ITestResult result) {
        for (String container : this.tmpContainers) {
            LOG.info("Cleaning up temporary container {}", (Object)container);
            try {
                this.dockerClient.stopContainer(container);
                this.dockerClient.kill(container);
                this.dockerClient.removeContainer(container);
            }
            catch (DockerException ignore) {}
        }
        for (String image : this.tmpImgs) {
            LOG.info("Cleaning up temporary image {}", (Object)image);
            try {
                this.dockerClient.removeImage(image);
            }
            catch (DockerException ignore) {}
        }
        LOG.info("################################## END OF {} ##################################\n", (Object)result.getName());
    }

    protected String logResponseStream(ClientResponse response) {
        String responseString;
        try {
            responseString = DockerClient.asString((ClientResponse)response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Container log: {}", (Object)responseString);
        return responseString;
    }
}

