/*
 * Decompiled with CFR 0.152.
 */
package com.kpelykh.docker.client.test;

import ch.lambdaj.Lambda;
import com.kpelykh.docker.client.DockerException;
import com.kpelykh.docker.client.model.ChangeLog;
import com.kpelykh.docker.client.model.CommitConfig;
import com.kpelykh.docker.client.model.Container;
import com.kpelykh.docker.client.model.ContainerConfig;
import com.kpelykh.docker.client.model.ContainerCreateResponse;
import com.kpelykh.docker.client.model.ContainerInspectResponse;
import com.kpelykh.docker.client.model.Image;
import com.kpelykh.docker.client.model.ImageInspectResponse;
import com.kpelykh.docker.client.model.Info;
import com.kpelykh.docker.client.model.Ports;
import com.kpelykh.docker.client.model.Version;
import com.kpelykh.docker.client.test.AbstractDockerClientTest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DockerClientTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(DockerClientTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testDockerVersion() throws DockerException {
        Version version = this.dockerClient.version();
        LOG.info(version.toString());
        DockerClientTest.assertTrue((version.getGoVersion().length() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertTrue((version.getVersion().length() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertEquals((int)StringUtils.split((String)version.getVersion(), (String)".").length, (int)3);
    }

    @Test
    public void testDockerInfo() throws DockerException {
        Info dockerInfo = this.dockerClient.info();
        LOG.info(dockerInfo.toString());
        DockerClientTest.assertTrue((boolean)dockerInfo.toString().contains("containers"));
        DockerClientTest.assertTrue((boolean)dockerInfo.toString().contains("images"));
        DockerClientTest.assertTrue((boolean)dockerInfo.toString().contains("debug"));
        DockerClientTest.assertTrue((dockerInfo.getContainers() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertTrue((dockerInfo.getImages() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertTrue((dockerInfo.getNFd() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertTrue((dockerInfo.getNGoroutines() > 0 ? 1 : 0) != 0);
        DockerClientTest.assertTrue((boolean)dockerInfo.isMemoryLimit());
    }

    @Test
    public void testDockerSearch() throws DockerException {
        List dockerSearch = this.dockerClient.search("busybox");
        LOG.info("Search returned {}", (Object)dockerSearch.toString());
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.equalTo((Object)"busybox")));
        MatcherAssert.assertThat((Object)dockerSearch, (Matcher)matcher);
        MatcherAssert.assertThat((Object)Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"name", (Matcher)Matchers.is((Object)"busybox")), (Iterable)dockerSearch).size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testImages() throws DockerException {
        List images = this.dockerClient.getImages(true);
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        Info info = this.dockerClient.info();
        MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.equalTo((Object)info.getImages()));
        Image img = (Image)images.get(0);
        MatcherAssert.assertThat((Object)img.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getVirtualSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)img.getTag(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)img.getRepository(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
    }

    @Test
    public void testListContainers() throws DockerException {
        List containers = this.dockerClient.listContainers(true);
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.notNullValue());
        LOG.info("Container List: {}", (Object)containers);
        int size = containers.size();
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"echo"});
        ContainerCreateResponse container1 = this.dockerClient.createContainer(containerConfig);
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container1.getId());
        this.tmpContainers.add(container1.getId());
        LOG.info("container id: " + container1.getId());
        List containers2 = this.dockerClient.listContainers(true);
        MatcherAssert.assertThat((Object)(size + 1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)containers2.size())));
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
        List filteredContainers = Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())), (Iterable)containers2);
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        for (Container container : filteredContainers) {
            LOG.info("container: " + container);
        }
        Container container2 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container2.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)container2.getImage(), (Matcher)Matchers.equalTo((Object)"busybox:latest"));
    }

    @Test
    public void testCreateContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"true"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.tmpContainers.add(container.getId());
    }

    @Test
    public void testStartContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"true"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        boolean add = this.tmpContainers.add(container.getId());
        this.dockerClient.startContainer(container.getId());
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect: {}", (Object)containerInspectResponse.toString());
        MatcherAssert.assertThat((Object)containerInspectResponse.config, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)containerInspectResponse.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)containerInspectResponse.getId(), (Matcher)Matchers.startsWith((String)container.getId()));
        MatcherAssert.assertThat((Object)containerInspectResponse.getImage(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().running, (Matcher)Matchers.is((Object)true));
        if (!containerInspectResponse.getState().running) {
            MatcherAssert.assertThat((Object)containerInspectResponse.getState().exitCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
    }

    @Test
    public void testWaitContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"true"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.tmpContainers.add(container.getId());
        this.dockerClient.startContainer(container.getId());
        int exitCode = this.dockerClient.waitContainer(container.getId());
        LOG.info("Container exit code: {}", (Object)exitCode);
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect: {}", (Object)containerInspectResponse.toString());
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().running, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().exitCode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)exitCode)));
    }

    @Test
    public void testLogs() throws DockerException, IOException {
        String snippet = "hello world";
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"/bin/echo", snippet});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        int exitCode = this.dockerClient.waitContainer(container.getId());
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        ClientResponse response = this.dockerClient.logContainer(container.getId());
        MatcherAssert.assertThat((Object)this.logResponseStream(response), (Matcher)Matchers.endsWith((String)snippet));
    }

    @Test
    public void testDiff() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"touch", "/test"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        boolean add = this.tmpContainers.add(container.getId());
        int exitCode = this.dockerClient.waitContainer(container.getId());
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        List filesystemDiff = this.dockerClient.containerDiff(container.getId());
        LOG.info("Container DIFF: {}", (Object)filesystemDiff.toString());
        MatcherAssert.assertThat((Object)filesystemDiff.size(), (Matcher)Matchers.equalTo((Object)1));
        ChangeLog testChangeLog = (ChangeLog)Lambda.selectUnique((Object)filesystemDiff, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"kind", (Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testStopContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"sleep", "9999"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        LOG.info("Stopping container: {}", (Object)container.getId());
        this.dockerClient.stopContainer(container.getId(), 2);
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect: {}", (Object)containerInspectResponse.toString());
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().running, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().exitCode, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testKillContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"sleep", "9999"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        LOG.info("Killing container: {}", (Object)container.getId());
        this.dockerClient.kill(container.getId());
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect: {}", (Object)containerInspectResponse.toString());
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().running, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().exitCode, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void restartContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"sleep", "9999"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect: {}", (Object)containerInspectResponse.toString());
        String startTime = containerInspectResponse.getState().startedAt;
        this.dockerClient.restart(container.getId(), 2);
        ContainerInspectResponse containerInspectResponse2 = this.dockerClient.inspectContainer(container.getId());
        LOG.info("Container Inspect After Restart: {}", (Object)containerInspectResponse2.toString());
        String startTime2 = containerInspectResponse2.getState().startedAt;
        MatcherAssert.assertThat((Object)startTime, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)startTime2)));
        MatcherAssert.assertThat((Object)containerInspectResponse.getState().running, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        this.dockerClient.kill(container.getId());
    }

    @Test
    public void removeContainer() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"true"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        this.dockerClient.startContainer(container.getId());
        this.dockerClient.waitContainer(container.getId());
        this.tmpContainers.add(container.getId());
        LOG.info("Removing container: {}", (Object)container.getId());
        this.dockerClient.removeContainer(container.getId());
        List containers2 = this.dockerClient.listContainers(true);
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container.getId()))));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
    }

    @Test
    public void testPullImage() throws DockerException, IOException {
        String testImage = "hackmann/empty";
        LOG.info("Removing image: {}", (Object)testImage);
        this.dockerClient.removeImage(testImage);
        Info info = this.dockerClient.info();
        LOG.info("Client info: {}", (Object)info.toString());
        int imgCount = info.getImages();
        LOG.info("Pulling image: {}", (Object)testImage);
        this.tmpImgs.add(testImage);
        ClientResponse response = this.dockerClient.pull(testImage);
        MatcherAssert.assertThat((Object)this.logResponseStream(response), (Matcher)Matchers.containsString((String)"Download complete"));
        info = this.dockerClient.info();
        LOG.info("Client info after pull, {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)imgCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(info.getImages())));
        ImageInspectResponse imageInspectResponse = this.dockerClient.inspectImage(testImage);
        LOG.info("Image Inspect: {}", (Object)imageInspectResponse.toString());
        MatcherAssert.assertThat((Object)imageInspectResponse, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void commitImage() throws DockerException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"touch", "/test"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        LOG.info("Commiting container: {}", (Object)container.toString());
        String imageId = this.dockerClient.commit(new CommitConfig(container.getId()));
        this.tmpImgs.add(imageId);
        ImageInspectResponse imageInspectResponse = this.dockerClient.inspectImage(imageId);
        LOG.info("Image Inspect: {}", (Object)imageInspectResponse.toString());
        MatcherAssert.assertThat((Object)imageInspectResponse, (Matcher)HasFieldWithValue.hasField((String)"container", (Matcher)Matchers.startsWith((String)container.getId())));
        MatcherAssert.assertThat((Object)imageInspectResponse.getContainerConfig().getImage(), (Matcher)Matchers.equalTo((Object)"busybox"));
        ImageInspectResponse busyboxImg = this.dockerClient.inspectImage("busybox");
        MatcherAssert.assertThat((Object)imageInspectResponse.getParent(), (Matcher)Matchers.equalTo((Object)busyboxImg.getId()));
    }

    @Test
    public void testRemoveImage() throws DockerException, InterruptedException {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"touch", "/test"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        LOG.info("Commiting container {}", (Object)container.toString());
        String imageId = this.dockerClient.commit(new CommitConfig(container.getId()));
        this.tmpImgs.add(imageId);
        this.dockerClient.stopContainer(container.getId());
        this.dockerClient.kill(container.getId());
        this.dockerClient.removeContainer(container.getId());
        this.tmpContainers.remove(container.getId());
        LOG.info("Removing image: {}", (Object)imageId);
        this.dockerClient.removeImage(imageId);
        List containers = this.dockerClient.listContainers(true);
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)imageId))));
        MatcherAssert.assertThat((Object)containers, (Matcher)matcher);
    }

    @Test
    public void testRunShlex() throws DockerException {
        String[] commands;
        for (String command : commands = new String[]{"true", "echo \"The Young Descendant of Tepes & Septette for the Dead Princess\"", "echo -n 'The Young Descendant of Tepes & Septette for the Dead Princess'", "/bin/sh -c echo Hello World", "/bin/sh -c echo 'Hello World'", "echo 'Night of Nights'", "true && echo 'Night of Nights'"}) {
            LOG.info("Running command: [{}]", (Object)command);
            ContainerConfig containerConfig = new ContainerConfig();
            containerConfig.setImage("busybox");
            containerConfig.setCmd(commands);
            ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
            this.dockerClient.startContainer(container.getId());
            this.tmpContainers.add(container.getId());
            int exitcode = this.dockerClient.waitContainer(container.getId());
            MatcherAssert.assertThat((Object)exitcode, (Matcher)Matchers.equalTo((Object)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNginxDockerfileBuilder() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("nginx").getFile());
        ClientResponse response = this.dockerClient.build(baseDir);
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response.getEntityInputStream(), (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + "\n");
                LOG.info(line);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)response.getEntityInputStream());
        }
        String fullLog = logwriter.toString();
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        ImageInspectResponse imageInspectResponse = this.dockerClient.inspectImage(imageId);
        MatcherAssert.assertThat((Object)imageInspectResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)imageInspectResponse.toString());
        this.tmpImgs.add(imageInspectResponse.getId());
        MatcherAssert.assertThat((Object)imageInspectResponse.getAuthor(), (Matcher)Matchers.equalTo((Object)"Guillaume J. Charmes \"guillaume@dotcloud.com\""));
    }

    @Test
    public void testDockerBuilderAddUrl() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddUrl").getFile());
        this.dockerfileBuild(baseDir, "docker.io");
    }

    @Test
    public void testDockerBuilderAddFileInSubfolder() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddFileInSubfolder").getFile());
        this.dockerfileBuild(baseDir, "Successfully executed testrun.sh");
    }

    @Test
    public void testDockerBuilderAddFolder() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddFolder").getFile());
        this.dockerfileBuild(baseDir, "Successfully executed testAddFolder.sh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNetCatDockerfileBuilder() throws DockerException, IOException, InterruptedException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("netcat").getFile());
        ClientResponse response = this.dockerClient.build(baseDir);
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response.getEntityInputStream(), (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + "\n");
                LOG.info(line);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)response.getEntityInputStream());
        }
        String fullLog = logwriter.toString();
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        ImageInspectResponse imageInspectResponse = this.dockerClient.inspectImage(imageId);
        MatcherAssert.assertThat((Object)imageInspectResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)imageInspectResponse.toString());
        this.tmpImgs.add(imageInspectResponse.getId());
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage(imageInspectResponse.getId());
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.tmpContainers.add(container.getId());
        ContainerInspectResponse containerInspectResponse = this.dockerClient.inspectContainer(container.getId());
        MatcherAssert.assertThat((Object)containerInspectResponse.getId(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)containerInspectResponse.getNetworkSettings().ports, (Matcher)Matchers.notNullValue());
        for (String portstr : containerInspectResponse.getNetworkSettings().ports.getAllPorts().keySet()) {
            Ports.Port p = (Ports.Port)containerInspectResponse.getNetworkSettings().ports.getAllPorts().get(portstr);
            int port = Integer.valueOf(p.getHostPort());
            LOG.info("Checking port {} is open", (Object)port);
            MatcherAssert.assertThat((Object)DockerClientTest.available(port), (Matcher)Matchers.is((Object)false));
        }
        this.dockerClient.stopContainer(container.getId(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < 1100 || port > 60000) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dockerfileBuild(File baseDir, String expectedText) throws DockerException, IOException {
        ClientResponse response = this.dockerClient.build(baseDir);
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response.getEntityInputStream(), (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + "\n");
                LOG.info(line);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)response.getEntityInputStream());
        }
        String fullLog = logwriter.toString();
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage(imageId);
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainer(container.getId());
        this.dockerClient.waitContainer(container.getId());
        this.tmpContainers.add(container.getId());
        ClientResponse logResponse = this.dockerClient.logContainer(container.getId());
        MatcherAssert.assertThat((Object)this.logResponseStream(logResponse), (Matcher)Matchers.containsString((String)expectedText));
        return container.getId();
    }
}

