/*
 * Decompiled with CFR 0.152.
 */
package com.kpelykh.docker.client.test;

import com.kpelykh.docker.client.DockerClient;
import com.kpelykh.docker.client.DockerException;
import com.kpelykh.docker.client.model.CommitConfig;
import com.kpelykh.docker.client.model.ContainerConfig;
import com.kpelykh.docker.client.model.ContainerCreateResponse;
import com.kpelykh.docker.client.test.AbstractDockerClientTest;
import com.sun.jersey.api.client.ClientResponse;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DockerPushTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(DockerPushTest.class);
    String username;

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
        this.username = this.dockerClient.authConfig().getUsername();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testPushLatest() throws Exception {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage("busybox");
        containerConfig.setCmd(new String[]{"true"});
        ContainerCreateResponse container = this.dockerClient.createContainer(containerConfig);
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.tmpContainers.add(container.getId());
        LOG.info("Commiting container: {}", (Object)container.toString());
        CommitConfig commitConfig = new CommitConfig(container.getId());
        commitConfig.setRepo(this.username + "/busybox");
        String imageId = this.dockerClient.commit(commitConfig);
        this.logResponseStream(this.dockerClient.push(this.username + "/busybox"));
        this.dockerClient.removeImage(imageId);
        MatcherAssert.assertThat((Object)DockerClient.asString((ClientResponse)this.dockerClient.pull(this.username + "/busybox")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"404")));
    }

    @Test
    public void testNotExistentImage() throws Exception {
        MatcherAssert.assertThat((Object)this.logResponseStream(this.dockerClient.push(this.username + "/xxx")), (Matcher)Matchers.containsString((String)"error"));
    }
}

