/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.algorithm;

import com.algorithmia.algorithm.ReflectionHelper;
import com.algorithmia.algorithm.RequestHandler;
import com.algorithmia.algorithm.ResponseHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Handler<INPUT, OUTPUT, STATE> {
    private ReflectionHelper.DebuggableBifunction<INPUT, STATE, OUTPUT> applyWState;
    private ReflectionHelper.DebuggableFunction<INPUT, OUTPUT> apply;
    private Supplier<STATE> loadFunc;
    private STATE state;
    private RequestHandler<INPUT> in;
    private ResponseHandler out = new ResponseHandler();

    public Handler(Class clazz, ReflectionHelper.DebuggableBifunction<INPUT, STATE, OUTPUT> debuggableBifunction, Supplier<STATE> supplier) {
        this.applyWState = debuggableBifunction;
        this.loadFunc = supplier;
        Class<INPUT> clazz2 = this.getInputClass(clazz);
        this.in = new RequestHandler<INPUT>(clazz2);
    }

    public Handler(Class clazz, ReflectionHelper.DebuggableBifunction<INPUT, STATE, OUTPUT> debuggableBifunction) {
        this.applyWState = debuggableBifunction;
        Class<INPUT> clazz2 = this.getInputClass(clazz);
        this.in = new RequestHandler<INPUT>(clazz2);
    }

    public Handler(Class clazz, ReflectionHelper.DebuggableFunction<INPUT, OUTPUT> debuggableFunction) {
        this.apply = debuggableFunction;
        Class<INPUT> clazz2 = this.getInputClass(clazz);
        this.in = new RequestHandler<INPUT>(clazz2);
    }

    private void load() {
        if (this.loadFunc != null) {
            this.state = this.loadFunc.get();
            System.out.println("PIPE_INIT_COMPLETE");
            System.out.flush();
        }
    }

    private void executeWithoutState(Function<INPUT, OUTPUT> function, Stream<String> stream) {
        stream.forEach(string -> {
            INPUT INPUT = this.in.processRequest((String)string);
            Object r = function.apply(INPUT);
            this.out.writeToPipe(r);
        });
    }

    private void executeWithState(BiFunction<INPUT, STATE, OUTPUT> biFunction, Stream<String> stream) {
        stream.forEach(string -> {
            INPUT INPUT = this.in.processRequest((String)string);
            Object r = biFunction.apply(INPUT, this.state);
            this.out.writeToPipe(r);
        });
    }

    private void execute() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Stream<String> stream = bufferedReader.lines();
        if (this.applyWState != null && this.loadFunc != null) {
            this.load();
            this.executeWithState(this.applyWState, stream);
        } else if (this.apply != null) {
            this.executeWithoutState(this.apply, stream);
        } else {
            throw new RuntimeException("If using an load function with state, a load function must be defined as well.");
        }
    }

    private Class<INPUT> getInputClass(Class clazz) {
        Method[] methodArray;
        String string;
        if (this.applyWState != null) {
            string = ReflectionHelper.getMethodName(this.applyWState);
        } else if (this.apply != null) {
            string = ReflectionHelper.getMethodName(this.apply);
        } else {
            throw new RuntimeException("Either Apply(INPUT t) or Apply(INPUT t STATE s) must be defined.");
        }
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            Class<?>[] classArray = method.getParameterTypes();
            return classArray[0];
        }
        throw new RuntimeException("Unable to find the method reference called " + string + " in the provided class.");
    }

    public void setLoad(Supplier<STATE> supplier) {
        this.loadFunc = supplier;
    }

    public void serve() {
        try {
            this.execute();
        }
        catch (RuntimeException runtimeException) {
            this.out.writeErrorToPipe(runtimeException);
        }
    }
}

