/*
 * Decompiled with CFR 0.152.
 */
package com.pensio;

import com.pensio.AmountConversionException;
import com.pensio.Currency;
import com.pensio.UnknownCurrencyException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Amount {
    private final long amount;
    private final Currency currency;

    private Amount(long amount, Currency currency) {
        this.amount = amount;
        if (currency == null) {
            throw new UnknownCurrencyException();
        }
        this.currency = currency;
    }

    public static Amount get(long amount, Currency currency) {
        return new Amount(amount, currency);
    }

    public static Amount get(double amount, Currency currency) {
        return new Amount(Math.round(amount * 1000.0), currency);
    }

    public static Amount get(String amount, Currency currency) throws AmountConversionException {
        return new Amount(Amount.convertStringAmountToLongWithThreeDecimals(amount), currency);
    }

    public static Amount getFromMinorUnit(String amount, Currency currency) throws AmountConversionException {
        return new Amount(Amount.convertStringAmountInMinorUnitToLongWithThreeDecimals(amount, currency), currency);
    }

    public static Amount get(String amount, String currency) throws AmountConversionException {
        return new Amount(Amount.convertStringAmountToLongWithThreeDecimals(amount), Currency.valueOf(currency));
    }

    public static Amount get(BigDecimal amount, Currency currency) {
        return new Amount(Math.round(amount.doubleValue() * 1000.0), currency);
    }

    public long getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigInteger getAmountInMinorUnit() {
        return BigInteger.valueOf((long)((double)this.amount / Math.pow(10.0, 3 - this.currency.getDecimals())));
    }

    public Double getAmountDouble() {
        return Double.valueOf(this.getAmountString());
    }

    public String getAmountString() {
        return Amount.convertLongWithThreeDecimalsToStringWithTwoDecimals(this.amount, this.currency);
    }

    private static long convertStringAmountInMinorUnitToLongWithThreeDecimals(String amount, Currency currency) throws AmountConversionException {
        return (long)((double)Integer.valueOf(amount).intValue() * Math.pow(10.0, 3 - currency.getDecimals()));
    }

    private static long convertStringAmountToLongWithThreeDecimals(String amount) throws AmountConversionException {
        if (amount == null || amount.length() == 0) {
            return 0L;
        }
        if (!amount.matches("^-?(\\d+|\\d*\\.\\d+|\\d+\\.\\d*)$")) {
            throw new AmountConversionException("Invalid amount: " + amount);
        }
        boolean isNegative = false;
        if (amount.startsWith("-")) {
            isNegative = true;
        }
        amount = amount.replace("-", "");
        String[] amountParts = (amount = amount.replaceAll("0+$", "")).split("\\.");
        if ("".equals(amountParts[0])) {
            amountParts[0] = "0";
        }
        long result = Amount.getLongFromStringParts(amount, amountParts);
        if (isNegative) {
            result = -1L * result;
        }
        return result;
    }

    private static long getLongFromStringParts(String amount, String[] amountParts) throws AmountConversionException {
        long result;
        if (amountParts.length > 1) {
            if (amountParts[1].length() > 3) {
                throw new AmountConversionException("Too many decimals when attempting to convert " + amount + " to long");
            }
            while (amountParts[1].length() < 3) {
                amountParts[1] = amountParts[1] + "0";
            }
            result = Long.parseLong(amountParts[0] + amountParts[1]);
        } else {
            result = Long.parseLong(amountParts[0] + "000");
        }
        return result;
    }

    private static String convertLongWithThreeDecimalsToStringWithTwoDecimals(long amount, Currency currency) {
        String negativePrefix = "";
        if (amount < 0L) {
            amount *= -1L;
            negativePrefix = "-";
        }
        long digitsPow = (long)Math.pow(10.0, 3 - currency.getDecimals());
        String digitPart = "" + (amount /= digitsPow) / (long)Math.pow(10.0, currency.getDecimals());
        String decimalPart = "" + amount % (long)Math.pow(10.0, currency.getDecimals());
        while (decimalPart.length() < 3) {
            decimalPart = "0" + decimalPart;
        }
        return negativePrefix + digitPart + (String)(currency.getDecimals() > 0 ? "." + decimalPart.substring(3 - currency.getDecimals()) : "");
    }

    public String toString() {
        return this.getAmountString() + " " + String.valueOf((Object)this.getCurrency());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Amount)) {
            return false;
        }
        Amount objAmount = (Amount)obj;
        return objAmount.getCurrency() == this.getCurrency() && objAmount.getAmount() == this.getAmount();
    }

    public Amount to(Currency to, double rate) {
        return new Amount(Math.round(rate * (double)this.amount), to);
    }
}

