/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateHelper {
    public Date currentTime() {
        return new Date();
    }

    public Date currentUTC() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime();
    }

    public boolean isToday(Date date) {
        Date today = this.currentTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(today);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public boolean thisYear(Date date) {
        Date today = this.currentTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(today);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1);
    }

    public int getYear() {
        Date today = this.currentTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(today);
        return cal1.get(1);
    }

    public int getYear(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        return cal1.get(1);
    }

    public int getMonth(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        return cal1.get(2) + 1;
    }

    public int getHours(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        return now.get(11);
    }

    public int getMinutes(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        return now.get(12);
    }

    public int getSeconds(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        return now.get(13);
    }

    public int getSecondsSinceMidnight(Date date) {
        return this.getHours(date) * 3600 + this.getMinutes(date) * 60 + this.getSeconds(date);
    }

    public static Date newDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hourOfDay, minute, second);
        return cal.getTime();
    }

    public boolean sameDay(Date date1, Date date2) {
        return DateHelper.formatDate("yyyyMMdd", date1).equals(DateHelper.formatDate("yyyyMMdd", date2));
    }

    public static String formatDate(String format, Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date parseDate(String format, String date) throws ParseException {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public Date add(Date date, DateValue dateValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        dateValue.add(calendar);
        return calendar.getTime();
    }

    public static abstract class DateValue {
        private int value;

        public DateValue(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void add(Calendar calendar) {
            calendar.add(this.getField(), this.value);
        }

        protected abstract int getField();
    }

    public static class Years
    extends DateValue {
        public Years(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 1;
        }
    }

    public static class Months
    extends DateValue {
        public Months(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 2;
        }
    }

    public static class Days
    extends DateValue {
        public Days(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 5;
        }
    }

    public static class Hours
    extends DateValue {
        public Hours(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 10;
        }
    }

    public static class Minutes
    extends DateValue {
        public Minutes(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 12;
        }
    }

    public static class Seconds
    extends DateValue {
        public Seconds(int value) {
            super(value);
        }

        @Override
        protected int getField() {
            return 13;
        }
    }
}

