/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api;

import com.pensio.api.HTTPHelper;
import com.pensio.api.PensioAPIException;
import com.pensio.api.SdkVersion;
import com.pensio.api.generated.APIResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public abstract class PensioAbstractAPI {
    protected String baseURL;
    protected String username;
    protected String password;
    protected JAXBContext jc;
    protected HTTPHelper httpHelper;

    public PensioAbstractAPI(String baseURL, String username, String password) {
        this.baseURL = baseURL;
        this.username = username;
        this.password = password;
        this.httpHelper = new HTTPHelper();
        try {
            this.jc = JAXBContext.newInstance((String)"com.pensio.api.generated");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        return this.jc.createUnmarshaller();
    }

    protected String getSdkVersion() {
        return SdkVersion.current();
    }

    protected APIResponse getAPIResponse(String method, Map<String, String> params) throws PensioAPIException {
        try {
            InputStream inStream = this.httpHelper.doPost(this.baseURL + this.getAppAPIPath() + method, params, this.username, this.password, this.getSdkVersion());
            JAXBElement result = (JAXBElement)this.getUnmarshaller().unmarshal(inStream);
            APIResponse response = (APIResponse)result.getValue();
            if (response.getHeader().getErrorCode() != 0) {
                throw new PensioAPIException(response.getHeader());
            }
            return response;
        }
        catch (Exception e) {
            throw new PensioAPIException(e);
        }
    }

    protected void addParam(HashMap<String, String> params, String key, String value) {
        if (value != null) {
            params.put(key, value);
        }
    }

    protected String getString(InputStream inStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        StringBuffer text = new StringBuffer();
        while ((line = br.readLine()) != null) {
            text.append(line);
        }
        return text.toString();
    }

    protected abstract String getAppAPIPath();
}

