/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api;

import com.csvreader.CsvReader;
import com.pensio.Amount;
import com.pensio.TaxType;
import com.pensio.api.DateHelper;
import com.pensio.api.FundingRecord;
import com.pensio.api.HttpMethod;
import com.pensio.api.PaymentRequestResponse;
import com.pensio.api.PaymentRequestResponseImpl;
import com.pensio.api.PensioAPIException;
import com.pensio.api.PensioAbstractAPI;
import com.pensio.api.generated.APIResponse;
import com.pensio.api.request.CaptureReservationRequest;
import com.pensio.api.request.CardWalletAuthorizeRequest;
import com.pensio.api.request.CardWalletSessionRequest;
import com.pensio.api.request.ChargeSubscriptionRequest;
import com.pensio.api.request.CreateInvoiceReservationRequest;
import com.pensio.api.request.CustomerInfo;
import com.pensio.api.request.FundingListRequest;
import com.pensio.api.request.MultiPaymentRequestChild;
import com.pensio.api.request.MultiPaymentRequestParent;
import com.pensio.api.request.OrderLine;
import com.pensio.api.request.PaymentInfo;
import com.pensio.api.request.PaymentRequest;
import com.pensio.api.request.PaymentReservationRequest;
import com.pensio.api.request.RefundRequest;
import com.pensio.api.request.ReleaseReservationRequest;
import com.pensio.api.request.ReserveSubscriptionChargeRequest;
import com.pensio.api.request.TransactionsRequest;
import com.pensio.api.request.UpdateOrderRequest;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class PensioMerchantAPI
extends PensioAbstractAPI {
    private static final SimpleDateFormat BIRTH_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public PensioMerchantAPI(String baseURL, String username, String password) {
        super(baseURL, username, password);
    }

    public boolean login() throws PensioAPIException {
        APIResponse response = this.getAPIResponse("login", HttpMethod.POST, new HashMap<String, String>());
        return "OK".equals(response.getBody().getResult());
    }

    public PaymentRequestResponse createPaymentRequest(PaymentRequest paymentRequest) throws PensioAPIException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            this.setPaymentRequestParameters(paymentRequest, params);
            APIResponse response = this.getAPIResponse("createPaymentRequest", HttpMethod.POST, params);
            PaymentRequestResponseImpl paymentRequestResponseImpl = new PaymentRequestResponseImpl().setUrl(new URL(response.getBody().getUrl())).setPaymentRequestId(response.getBody().getPaymentRequestId());
            if (response.getBody().getAppUrl() != null) {
                paymentRequestResponseImpl.setAppUrl(new URL(response.getBody().getAppUrl()));
            }
            return paymentRequestResponseImpl;
        }
        catch (MalformedURLException e) {
            throw new PensioAPIException(e);
        }
    }

    public APIResponse createInvoiceReservation(CreateInvoiceReservationRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.setInvoiceReservationRequestParameters(request, params);
        return this.getAPIResponse("createInvoiceReservation", HttpMethod.POST, params);
    }

    public APIResponse updateOrder(UpdateOrderRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.setUpdateOrderRequestParameters(request, params);
        return this.getAPIResponse("updateOrder", HttpMethod.POST, params);
    }

    public APIResponse reservation(PaymentReservationRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.setPaymentRequestParameters(request, params);
        this.setCreditCardRequestParameters(request, params);
        this.setPaymentSource(request, params);
        return this.getAPIResponse("reservation", HttpMethod.POST, params);
    }

    private void setPaymentSource(PaymentReservationRequest request, HashMap<String, String> params) {
        if (request.getSource() != null) {
            this.addParam(params, "payment_source", request.getSource().name());
        }
    }

    public APIResponse capture(CaptureReservationRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "transaction_id", request.getTransactionId());
        this.addParam(params, "amount", request.getAmountString());
        this.addParam(params, "reconciliation_identifier", request.getReconciliationIdentifier());
        this.addParam(params, "invoice_number", request.getInvoiceNumber());
        this.addParam(params, "sales_tax", request.getSalesTax());
        OrderLine[] orderLines = request.getOrderLines();
        this.addOrderLines("orderLines", params, Arrays.asList(orderLines));
        return this.getAPIResponse("captureReservation", HttpMethod.POST, params);
    }

    public APIResponse refund(RefundRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "transaction_id", request.getPaymentId());
        this.addParam(params, "amount", request.getAmountString());
        this.addParam(params, "reconciliation_identifier", request.getReconciliationIdentifier());
        OrderLine[] orderLines = request.getOrderLines();
        this.addOrderLines("orderLines", params, Arrays.asList(orderLines));
        return this.getAPIResponse("refundCapturedReservation", HttpMethod.POST, params);
    }

    public APIResponse chargeSubscription(ChargeSubscriptionRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "agreement[id]", request.getAgreementId());
        this.addParam(params, "amount", request.getAmountString());
        this.addParam(params, "reconciliation_identifier", request.getReconciliationIdentifier());
        if (request.getAgreementUnscheduledType() != null) {
            this.addParam(params, "agreement[unscheduled_type]", request.getAgreementUnscheduledType().name());
        }
        if (!request.getPaymentInfos().getAll().isEmpty()) {
            for (PaymentInfo paymentInfo : request.getPaymentInfos().getAll()) {
                this.addParam(params, "transaction_info[" + paymentInfo.getKey() + "]", paymentInfo.getValue());
            }
        }
        if (request.getCallbackOk() != null && !request.getCallbackOk().isEmpty()) {
            this.addParam(params, "config[callback_ok]", request.getCallbackOk());
        }
        if (request.getCallbackFail() != null && !request.getCallbackFail().isEmpty()) {
            this.addParam(params, "config[callback_fail]", request.getCallbackFail());
        }
        return this.getAPIResponse("chargeSubscription", HttpMethod.POST, params);
    }

    public APIResponse reserveSubscriptionCharge(ReserveSubscriptionChargeRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "agreement[id]", request.getAgreementId());
        this.addParam(params, "amount", request.getAmountString());
        if (request.getAgreementUnscheduledType() != null) {
            this.addParam(params, "agreement[unscheduled_type]", request.getAgreementUnscheduledType().name());
        }
        if (!request.getPaymentInfos().getAll().isEmpty()) {
            for (PaymentInfo paymentInfo : request.getPaymentInfos().getAll()) {
                this.addParam(params, "transaction_info[" + paymentInfo.getKey() + "]", paymentInfo.getValue());
            }
        }
        if (request.getCallbackOk() != null && !request.getCallbackOk().isEmpty()) {
            this.addParam(params, "config[callback_ok]", request.getCallbackOk());
        }
        if (request.getCallbackFail() != null && !request.getCallbackFail().isEmpty()) {
            this.addParam(params, "config[callback_fail]", request.getCallbackFail());
        }
        return this.getAPIResponse("reserveSubscriptionCharge", HttpMethod.POST, params);
    }

    public APIResponse fundingList(FundingListRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "page", String.valueOf(request.getPage()));
        return this.getAPIResponse("fundingList", HttpMethod.GET, params);
    }

    public APIResponse getTerminals() throws PensioAPIException {
        return this.getAPIResponse("getTerminals", HttpMethod.GET, new HashMap<String, String>());
    }

    public List<FundingRecord> downloadFunding(String downloadLink) throws PensioAPIException {
        try {
            InputStream inStream = this.httpHelper.doPost(downloadLink, new HashMap<String, String>(), this.username, this.password, this.getSdkVersion());
            CsvReader reader = new CsvReader(inStream, ';', Charset.forName("UTF-8"));
            ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
            if (reader.readHeaders()) {
                while (reader.readRecord()) {
                    FundingRecord record = new FundingRecord();
                    String date = reader.get("Date");
                    System.out.println("Date: " + date);
                    if (date.matches("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}")) {
                        record.setFundingDate(DateHelper.parseDate("yyyy-MM-dd hh:mm:ss", date));
                    } else {
                        record.setFundingDate(DateHelper.parseDate("yyyy-MM-dd", date));
                    }
                    record.setRecordType(reader.get("Type"));
                    record.setId(reader.get("ID"));
                    record.setReconciliationIdentifier(reader.get("Reconciliation Identifier"));
                    record.setPaymentId(reader.get("Payment"));
                    record.setOrderId(reader.get("Order"));
                    record.setTerminal(reader.get("Terminal"));
                    record.setShop(reader.get("Shop"));
                    record.setPaymentAmount(Amount.get(reader.get("Transaction Amount"), reader.get("Transaction Currency")));
                    record.setFundingAmount(Amount.get(reader.get("Settlement Amount"), reader.get("Settlement Currency")));
                    String exRate = reader.get("Exchange Rate");
                    if (exRate == null || exRate.length() == 0) {
                        record.setExchangeRate(1.0);
                    } else {
                        record.setExchangeRate(Double.parseDouble(exRate));
                    }
                    record.setFixedFeeAmount(Amount.get(reader.get("Fixed Fee"), reader.get("Settlement Currency")));
                    record.setFixedFeeVatAmount(Amount.get(reader.get("Fixed Fee VAT"), reader.get("Settlement Currency")));
                    record.setRateBasedFeeAmount(Amount.get(reader.get("Rate Based Fee"), reader.get("Settlement Currency")));
                    record.setRateBasedFeeVatAmount(Amount.get(reader.get("Rate Based Fee VAT"), reader.get("Settlement Currency")));
                    result.add(record);
                }
            }
            reader.close();
            return result;
        }
        catch (Exception e) {
            throw new PensioAPIException(e);
        }
    }

    public APIResponse release(ReleaseReservationRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "transaction_id", request.getPaymentId());
        return this.getAPIResponse("releaseReservation", HttpMethod.POST, params);
    }

    public APIResponse queryGiftCard(PaymentReservationRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getGiftCard() == null) {
            this.addParam(params, "terminal", request.getTerminal());
            this.addParam(params, "giftcard[token]", request.getGiftCardToken());
        } else {
            this.addParam(params, "terminal", request.getTerminal());
            this.addParam(params, "giftcard[account_identifier]", request.getGiftCard().getAccountIdentifier());
            this.addParam(params, "giftcard[provider]", request.getGiftCard().getProvider());
        }
        return this.getAPIResponse("queryGiftCard", HttpMethod.POST, params);
    }

    private void setCreditCardRequestParameters(PaymentReservationRequest request, HashMap<String, String> params) {
        if (request.getCreditCard() == null) {
            return;
        }
        this.addParam(params, "credit_card_token", request.getCreditCard().getToken());
        this.addParam(params, "cardnum", request.getCreditCard().getCardNumber());
        this.addParam(params, "emonth", request.getCreditCard().getExpiryMonth());
        this.addParam(params, "eyear", request.getCreditCard().getExpiryYear());
        this.addParam(params, "cvc", request.getCreditCard().getCvc());
    }

    protected void setPaymentRequestParameters(PaymentRequest<?> paymentRequest, HashMap<String, String> params) {
        this.addParam(params, "terminal", paymentRequest.getTerminal());
        this.addParam(params, "amount", paymentRequest.getAmount().getAmountString());
        this.addParam(params, "currency", paymentRequest.getAmount().getCurrency().name());
        this.addParam(params, "shop_orderid", paymentRequest.getShopOrderId());
        this.addAuthType(paymentRequest, params);
        if (paymentRequest.getUsePayPass()) {
            this.addParam(params, "use_paypass", "true");
        }
        this.addParam(params, "cookie", paymentRequest.getCookie());
        this.addParam(params, "ccToken", paymentRequest.getCreditCardToken());
        this.addParam(params, "language", paymentRequest.getLanguage());
        this.addParam(params, "shipping_method", paymentRequest.getShippingMethod());
        this.addParam(params, "customer_created_date", DateHelper.formatDate("yyyy-MM-dd HH:mm:ss", paymentRequest.getCustomerCreateAt()));
        if (paymentRequest.getConfig() != null) {
            this.addParam(params, "config[callback_form]", paymentRequest.getConfig().getCallbackForm());
            this.addParam(params, "config[callback_fail]", paymentRequest.getConfig().getCallbackFail());
            this.addParam(params, "config[callback_notification]", paymentRequest.getConfig().getCallbackNotification());
            this.addParam(params, "config[callback_ok]", paymentRequest.getConfig().getCallbackOk());
            this.addParam(params, "config[callback_open]", paymentRequest.getConfig().getCallbackOpen());
            this.addParam(params, "config[callback_redirect]", paymentRequest.getConfig().getCallbackRedirect());
            this.addParam(params, "config[callback_verify_order]", paymentRequest.getConfig().getCallbackVerifyOrder());
            this.addParam(params, "fraud_service", paymentRequest.getConfig().getFraudService());
            this.addParam(params, "account_offer", paymentRequest.getConfig().getAccountOffer());
        }
        this.addCustomerInfo(paymentRequest, params);
        this.addPaymentInfo(paymentRequest, params);
        this.addOrderLines("orderLines", params, paymentRequest.getOrderLines());
        if (paymentRequest.getAgreementConfig() != null) {
            this.addParam(params, "agreement[id]", paymentRequest.getAgreementConfig().getAgreementId());
            this.addParam(params, "agreement[type]", paymentRequest.getAgreementConfig().getAgreementType() != null ? paymentRequest.getAgreementConfig().getAgreementType().name() : null);
            this.addParam(params, "agreement[unscheduled_type]", paymentRequest.getAgreementConfig().getAgreementUnscheduledType() != null ? paymentRequest.getAgreementConfig().getAgreementUnscheduledType().name() : null);
            this.addParam(params, "agreement[expiry]", paymentRequest.getAgreementConfig().getAgreementExpiry() != null ? DateHelper.formatDate("yyyyMMdd", paymentRequest.getAgreementConfig().getAgreementExpiry()) : null);
            this.addParam(params, "agreement[frequency]", paymentRequest.getAgreementConfig().getAgreementFrequency());
            this.addParam(params, "agreement[next_charge_date]", paymentRequest.getAgreementConfig().getAgreementNextChargeDate() != null ? DateHelper.formatDate("yyyyMMdd", paymentRequest.getAgreementConfig().getAgreementNextChargeDate()) : null);
            this.addParam(params, "agreement[admin_url]", paymentRequest.getAgreementConfig().getAgreementAdminUrl());
            this.addParam(params, "agreement[retention_period]", paymentRequest.getAgreementConfig().getRetentionPeriod());
        }
        if (paymentRequest.getAgreementType() != null) {
            this.addParam(params, "agreement[type]", paymentRequest.getAgreementConfig().getAgreementType().name());
        }
    }

    protected void setInvoiceReservationRequestParameters(CreateInvoiceReservationRequest request, HashMap<String, String> params) {
        this.addParam(params, "terminal", request.getTerminal());
        this.addParam(params, "shop_orderid", request.getShopOrderId());
        this.addParam(params, "amount", request.getAmount().getAmountString());
        this.addParam(params, "currency", request.getAmount().getCurrency().name());
        this.addCustomerInfo(request, params);
        this.addAuthType(request, params);
        this.addPaymentInfo(request, params);
        this.addParam(params, "accountNumber", request.getAccountNumber());
        this.addParam(params, "bankCode", request.getBankCode());
        if (request.getFraudService() != null) {
            this.addParam(params, "fraud_service", request.getFraudService().toString());
        }
        if (request.getPaymentSource() != null) {
            this.addParam(params, "payment_source", request.getPaymentSource().toString());
        }
        this.addOrderLines("orderLines", params, request.getOrderLines());
        this.addParam(params, "organisationNumber", request.getOrganisationNumber());
        this.addParam(params, "personalIdentifyNumber", request.getPersonalIdentifyNumber());
        this.addParam(params, "birthDate", DateHelper.formatDate("yyyy-MM-dd'T'HH:mm:ss.SSSZ", request.getBirthDate()));
    }

    protected void setUpdateOrderRequestParameters(UpdateOrderRequest request, HashMap<String, String> params) {
        this.addParam(params, "payment_id", request.getPaymentId());
        this.addOrderLines("orderLines", params, request.getOrderLines());
    }

    protected APIResponse getAPIResponse(String method, HttpMethod httpMethod, Map<String, String> requestVars) throws PensioAPIException {
        try {
            InputStream inStream = null;
            inStream = HttpMethod.GET.equals((Object)httpMethod) ? this.httpHelper.doGet(this.baseURL + this.getAppAPIPath() + method, requestVars, this.username, this.password, this.getSdkVersion()) : this.httpHelper.doPost(this.baseURL + this.getAppAPIPath() + method, requestVars, this.username, this.password, this.getSdkVersion());
            JAXBElement result = (JAXBElement)this.getUnmarshaller().unmarshal(inStream);
            APIResponse response = (APIResponse)result.getValue();
            if (response.getHeader().getErrorCode() != 0) {
                throw new PensioAPIException(response.getHeader());
            }
            return response;
        }
        catch (Exception e) {
            throw new PensioAPIException(e);
        }
    }

    public PaymentRequestResponse createMultiPaymentRequest(MultiPaymentRequestParent multiPaymentRequest) throws PensioAPIException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            this.setMultiPaymentRequestParameters(multiPaymentRequest, params);
            APIResponse response = this.getAPIResponse("createMultiPaymentRequest", HttpMethod.POST, params);
            PaymentRequestResponseImpl paymentRequestResponseImpl = new PaymentRequestResponseImpl().setUrl(new URL(response.getBody().getUrl()));
            if (response.getBody().getAppUrl() != null) {
                paymentRequestResponseImpl.setAppUrl(new URL(response.getBody().getAppUrl()));
            }
            return paymentRequestResponseImpl;
        }
        catch (MalformedURLException e) {
            throw new PensioAPIException(e);
        }
    }

    public APIResponse parsePostBackXMLParameter(String xmlParameter) throws PensioAPIException {
        try {
            JAXBElement result = (JAXBElement)this.getUnmarshaller().unmarshal((Reader)new StringReader(xmlParameter));
            return (APIResponse)result.getValue();
        }
        catch (JAXBException e) {
            throw new PensioAPIException((Exception)((Object)e));
        }
    }

    public APIResponse transactions(TransactionsRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "transaction_id", request.getPaymentId());
        return this.getAPIResponse("payments", HttpMethod.GET, params);
    }

    private void setMultiPaymentRequestParameters(MultiPaymentRequestParent multiPaymentRequest, HashMap<String, String> params) {
        this.addParam(params, "terminal", multiPaymentRequest.getTerminal());
        this.addParam(params, "currency", multiPaymentRequest.getCurrency().name());
        this.addParam(params, "shop_orderid", multiPaymentRequest.getShopOrderId());
        if (multiPaymentRequest.getAuthType() != null) {
            this.addParam(params, "type", multiPaymentRequest.getAuthType().name());
        }
        this.addParam(params, "cookie", multiPaymentRequest.getCookie());
        this.addParam(params, "ccToken", multiPaymentRequest.getCreditCardToken());
        this.addParam(params, "language", multiPaymentRequest.getLanguage());
        if (multiPaymentRequest.getConfig() != null) {
            this.addParam(params, "config[callback_form]", multiPaymentRequest.getConfig().getCallbackForm());
            this.addParam(params, "config[callback_fail]", multiPaymentRequest.getConfig().getCallbackFail());
            this.addParam(params, "config[callback_notification]", multiPaymentRequest.getConfig().getCallbackNotification());
            this.addParam(params, "config[callback_ok]", multiPaymentRequest.getConfig().getCallbackOk());
            this.addParam(params, "config[callback_open]", multiPaymentRequest.getConfig().getCallbackOpen());
            this.addParam(params, "config[callback_redirect]", multiPaymentRequest.getConfig().getCallbackRedirect());
            this.addParam(params, "fraud_service", multiPaymentRequest.getConfig().getFraudService());
        }
        if (multiPaymentRequest.getCustomerInfo() != null) {
            this.setCustomerInfo(params, multiPaymentRequest.getCustomerInfo());
        }
        for (PaymentInfo paymentInfo : multiPaymentRequest.getPaymentInfos().getAll()) {
            this.addParam(params, "transaction_info[" + paymentInfo.getKey() + "]", paymentInfo.getValue());
        }
        int i = 0;
        boolean orderLineIdx = false;
        for (MultiPaymentRequestChild multiPaymentRequestChild : multiPaymentRequest.getMultiPaymentRequestChildren()) {
            this.addParam(params, "multi[" + i + "][terminal]", multiPaymentRequestChild.getTerminal());
            this.addParam(params, "multi[" + i + "][amount]", String.valueOf(multiPaymentRequestChild.getAmount()));
            this.addParam(params, "multi[" + i + "][shop_orderid]", multiPaymentRequestChild.getShopOrderId());
            if (multiPaymentRequestChild.getAuthType() != null) {
                this.addParam(params, "multi[" + i + "][type]", multiPaymentRequestChild.getAuthType().name());
            }
            this.addParam(params, "multi[" + i + "][language]", multiPaymentRequestChild.getLanguage());
            this.addParam(params, "multi[" + i + "][shipping_method]", multiPaymentRequestChild.getShippingMethod());
            this.addParam(params, "multi[" + i + "][sale_reconciliation_identifier]", multiPaymentRequestChild.getSaleReconciliationIdentifier());
            for (PaymentInfo paymentInfo : multiPaymentRequestChild.getPaymentInfos().getAll()) {
                this.addParam(params, "multi[" + i + "][transaction_info][" + paymentInfo.getKey() + "]", paymentInfo.getValue());
            }
            this.addOrderLines("multi[" + i + "][orderLines]", params, multiPaymentRequestChild.getOrderLines());
            ++i;
        }
    }

    private void setCustomerInfo(HashMap<String, String> params, CustomerInfo customerInfo) {
        this.addParam(params, "organisation_number", customerInfo.getOrganisationNumber());
        this.addParam(params, "customer_info[email]", customerInfo.getEmail());
        this.addParam(params, "customer_info[bank_name]", customerInfo.getBankName());
        this.addParam(params, "customer_info[bank_phone]", customerInfo.getBankPhone());
        this.addParam(params, "customer_info[customer_phone]", customerInfo.getCustomerPhone());
        this.addParam(params, "customer_info[username]", customerInfo.getUsername());
        this.addParam(params, "customer_info[client_ip]", customerInfo.getClientIp());
        if (customerInfo.getBirthDate() != null) {
            this.addParam(params, "customer_info[birthdate]", BIRTH_DATE_FORMATTER.format(customerInfo.getBirthDate()));
        }
        if (customerInfo.getGender() != null) {
            this.addParam(params, "customer_info[gender]", customerInfo.getGender().name());
        }
        if (customerInfo.getBillingAddress() != null) {
            this.addParam(params, "customer_info[billing_address]", customerInfo.getBillingAddress().getAddress());
            this.addParam(params, "customer_info[billing_city]", customerInfo.getBillingAddress().getCity());
            this.addParam(params, "customer_info[billing_country]", customerInfo.getBillingAddress().getCountry());
            this.addParam(params, "customer_info[billing_firstname]", customerInfo.getBillingAddress().getFirstname());
            this.addParam(params, "customer_info[billing_lastname]", customerInfo.getBillingAddress().getLastname());
            this.addParam(params, "customer_info[billing_postal]", customerInfo.getBillingAddress().getPostal());
            this.addParam(params, "customer_info[billing_region]", customerInfo.getBillingAddress().getRegion());
        }
        if (customerInfo.getShippingAddress() != null) {
            this.addParam(params, "customer_info[shipping_address]", customerInfo.getShippingAddress().getAddress());
            this.addParam(params, "customer_info[shipping_city]", customerInfo.getShippingAddress().getCity());
            this.addParam(params, "customer_info[shipping_country]", customerInfo.getShippingAddress().getCountry());
            this.addParam(params, "customer_info[shipping_firstname]", customerInfo.getShippingAddress().getFirstname());
            this.addParam(params, "customer_info[shipping_lastname]", customerInfo.getShippingAddress().getLastname());
            this.addParam(params, "customer_info[shipping_postal]", customerInfo.getShippingAddress().getPostal());
            this.addParam(params, "customer_info[shipping_region]", customerInfo.getShippingAddress().getRegion());
        }
    }

    private void addOrderLines(String prepend, HashMap<String, String> params, List<OrderLine> orderLines) {
        int orderLineIdx = 0;
        for (OrderLine orderLine : orderLines) {
            this.addParam(params, prepend + "[" + orderLineIdx + "][description]", orderLine.getDescription());
            this.addParam(params, prepend + "[" + orderLineIdx + "][itemId]", orderLine.getItemId());
            this.addParam(params, prepend + "[" + orderLineIdx + "][quantity]", String.valueOf(orderLine.getQuantity()));
            this.addParam(params, prepend + "[" + orderLineIdx + "][unitPrice]", String.valueOf(orderLine.getUnitPrice()));
            if (orderLine.getTaxAmount() > 0.0) {
                this.addParam(params, prepend + "[" + orderLineIdx + "][" + TaxType.AMOUNT.getName() + "]", String.valueOf(orderLine.getTaxAmount()));
            }
            if (orderLine.getTaxPercent() > 0.0) {
                this.addParam(params, prepend + "[" + orderLineIdx + "][" + TaxType.PERCENT.getName() + "]", String.valueOf(orderLine.getTaxPercent()));
            }
            this.addParam(params, prepend + "[" + orderLineIdx + "][unitCode]", orderLine.getUnitCode());
            if (orderLine.getDiscount() != null) {
                this.addParam(params, prepend + "[" + orderLineIdx + "][discount]", String.valueOf(orderLine.getDiscount()));
            }
            this.addParam(params, prepend + "[" + orderLineIdx + "][goodsType]", orderLine.getGoodsType());
            this.addParam(params, prepend + "[" + orderLineIdx + "][imageUrl]", orderLine.getImageUrl());
            this.addParam(params, prepend + "[" + orderLineIdx + "][productUrl]", orderLine.getProductUrl());
            ++orderLineIdx;
        }
    }

    private void addCustomerInfo(PaymentRequest<?> paymentRequest, HashMap<String, String> params) {
        if (paymentRequest.getCustomerInfo() != null) {
            this.setCustomerInfo(params, paymentRequest.getCustomerInfo());
        }
    }

    private void addPaymentInfo(PaymentRequest<?> paymentRequest, HashMap<String, String> params) {
        for (PaymentInfo paymentInfo : paymentRequest.getPaymentInfos().getAll()) {
            this.addParam(params, "transaction_info[" + paymentInfo.getKey() + "]", paymentInfo.getValue());
        }
    }

    private void addAuthType(PaymentRequest<?> request, HashMap<String, String> params) {
        if (request.getAuthType() != null) {
            this.addParam(params, "type", request.getAuthType().name());
        }
    }

    public APIResponse cardWalletSession(CardWalletSessionRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "terminal", request.getTerminal());
        this.addParam(params, "validationUrl", request.getValidationUrl());
        this.addParam(params, "domain", request.getDomain());
        return this.getAPIResponse("cardWallet/session", HttpMethod.POST, params);
    }

    public APIResponse cardWalletAuthorize(CardWalletAuthorizeRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "provider_data", request.getProviderData());
        this.addParam(params, "sale_reconciliation_identifier", request.getSaleReconciliationIdentifier());
        this.addParam(params, "sale_invoice_number", request.getSaleInvoiceNumber());
        this.addParam(params, "sales_tax", request.getSalesTax());
        this.setPaymentRequestParameters(request, params);
        return this.getAPIResponse("cardWallet/authorize", HttpMethod.POST, params);
    }

    @Override
    protected String getAppAPIPath() {
        return "merchant/API/";
    }
}

