/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api;

import com.pensio.api.DateHelper;
import com.pensio.api.PensioAPIException;
import com.pensio.api.PensioAbstractAPI;
import com.pensio.api.generated.APIResponse;
import com.pensio.api.request.AuthType;
import com.pensio.api.request.BrowserData;
import com.pensio.api.request.CustomerInfo;
import com.pensio.api.request.CustomerInfoAddress;
import com.pensio.api.request.PaymentReservationRequest;
import com.pensio.api.request.Verify3dRequest;
import java.util.HashMap;

public class PensioProcessorAPI
extends PensioAbstractAPI {
    public PensioProcessorAPI(String baseURL, String username, String password) {
        super(baseURL, username, password);
    }

    @Override
    protected String getAppAPIPath() {
        return "processor/API/";
    }

    public APIResponse initiateGiftCardPayment(PaymentReservationRequest paymentRequest) throws PensioAPIException {
        if (paymentRequest.getGiftCard() == null && paymentRequest.getGiftCardToken() == null) {
            throw new PensioAPIException("A gift card must be supplied");
        }
        return this.getAPIResponse("initiateGiftCardPayment", this.setBaseInitiateParams(paymentRequest));
    }

    public APIResponse initiatePaymentRequest(PaymentReservationRequest paymentRequest) throws PensioAPIException {
        if (paymentRequest.getCreditCard() == null) {
            throw new PensioAPIException("A credit card must be supplied");
        }
        return this.getAPIResponse("initiatePayment", this.setBaseInitiateParams(paymentRequest));
    }

    public APIResponse reservationOfFixedAmount(PaymentReservationRequest paymentRequest) throws PensioAPIException {
        if (paymentRequest.getCreditCard() == null) {
            throw new PensioAPIException("A credit card must be supplied");
        }
        return this.getAPIResponse("reservationOfFixedAmount", this.setBaseInitiateParams(paymentRequest));
    }

    public APIResponse reservation(PaymentReservationRequest paymentRequest) throws PensioAPIException {
        if (paymentRequest.getCreditCard() == null) {
            throw new PensioAPIException("A credit card must be supplied");
        }
        return this.getAPIResponse("reservation", this.setBaseInitiateParams(paymentRequest));
    }

    public APIResponse reservationOfFixedAmountAndCapture(PaymentReservationRequest paymentRequest) throws PensioAPIException {
        if (paymentRequest.getCreditCard() == null) {
            throw new PensioAPIException("A credit card must be supplied");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        this.commonParams(params, paymentRequest);
        this.addParam(params, "type", AuthType.paymentAndCapture.toString());
        return this.getAPIResponse("reservationOfFixedAmountAndCapture", params);
    }

    public APIResponse verify3dSecure(Verify3dRequest request) throws PensioAPIException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "transactionId", request.getTransactionId());
        this.addParam(params, "3DSecureRegular[paRes]", request.getPaRes());
        this.addParam(params, "3DSecureRegular[MD]", request.getTransactionId());
        this.addParam(params, "3DSecureV2[3ds_data]", request.getThreeDSecureData());
        return this.getAPIResponse("verify3dSecure", params);
    }

    public void addCustomerInfoParams(PaymentReservationRequest paymentRequest, HashMap<String, String> params) {
        CustomerInfo customerInfo = paymentRequest.getCustomerInfo();
        this.addParam(params, "customer_info[email]", customerInfo.getEmail());
        this.addParam(params, "customer_info[customer_phone]", customerInfo.getCustomerPhone());
        this.addParam(params, "customer_info[username]", customerInfo.getUsername());
        this.addParam(params, "customer_info[bank_name]", customerInfo.getBankName());
        this.addParam(params, "customer_info[bank_phone]", customerInfo.getBankPhone());
        this.addParam(params, "customer_info[client_ip]", customerInfo.getClientIp());
        CustomerInfoAddress shippingAddress = customerInfo.getShippingAddress();
        this.addParam(params, "customer_info[shipping_firstname]", shippingAddress.getFirstname());
        this.addParam(params, "customer_info[shipping_lastname]", shippingAddress.getLastname());
        this.addParam(params, "customer_info[shipping_address]", shippingAddress.getAddress());
        this.addParam(params, "customer_info[shipping_city]", shippingAddress.getCity());
        this.addParam(params, "customer_info[shipping_region]", shippingAddress.getRegion());
        this.addParam(params, "customer_info[shipping_postal]", shippingAddress.getPostal());
        this.addParam(params, "customer_info[shipping_country]", shippingAddress.getCountry());
        CustomerInfoAddress billingAddress = customerInfo.getBillingAddress();
        this.addParam(params, "customer_info[billing_firstname]", billingAddress.getFirstname());
        this.addParam(params, "customer_info[billing_lastname]", billingAddress.getLastname());
        this.addParam(params, "customer_info[billing_address]", billingAddress.getAddress());
        this.addParam(params, "customer_info[billing_city]", billingAddress.getCity());
        this.addParam(params, "customer_info[billing_region]", billingAddress.getRegion());
        this.addParam(params, "customer_info[billing_postal]", billingAddress.getPostal());
        this.addParam(params, "customer_info[billing_country]", billingAddress.getCountry());
        BrowserData browserData = customerInfo.getBrowserData();
        this.addParam(params, "customer_info[client_time_zone]", browserData.getTimeZone());
        this.addParam(params, "customer_info[client_javascript_enabled]", browserData.getJavascriptEnabled());
        this.addParam(params, "customer_info[client_screen_width]", browserData.getScreenWidth());
        this.addParam(params, "customer_info[client_screen_height]", browserData.getScreenHeight());
        this.addParam(params, "customer_info[client_color_depth]", browserData.getColorDepth());
        this.addParam(params, "customer_info[client_java_enabled]", browserData.getJavaEnabled());
        this.addParam(params, "customer_info[client_forwarded_ip]", browserData.getForwardedIp());
        this.addParam(params, "customer_info[client_user_agent]", browserData.getUserAgent());
        this.addParam(params, "customer_info[client_accept]", browserData.getAccept());
        this.addParam(params, "customer_info[client_accept_language]", browserData.getAcceptLanguage());
    }

    private HashMap<String, String> setBaseInitiateParams(PaymentReservationRequest paymentRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.commonParams(params, paymentRequest);
        if (paymentRequest.getAuthType() != null) {
            this.addParam(params, "type", paymentRequest.getAuthType().name());
        }
        if (paymentRequest.getCustomerInfo() != null) {
            this.addCustomerInfoParams(paymentRequest, params);
        }
        return params;
    }

    public void commonParams(HashMap<String, String> params, PaymentReservationRequest paymentRequest) {
        this.addParam(params, "terminal", paymentRequest.getTerminal());
        if (paymentRequest.getAmount() != null) {
            this.addParam(params, "amount", paymentRequest.getAmount().getAmountString());
            this.addParam(params, "currency", paymentRequest.getAmount().getCurrency().name());
        }
        this.addParam(params, "shop_orderid", paymentRequest.getShopOrderId());
        if (paymentRequest.getSource() != null) {
            this.addParam(params, "payment_source", paymentRequest.getSource().name());
        }
        if (paymentRequest.getCreditCard() != null) {
            this.addParam(params, "cardnum", paymentRequest.getCreditCard().getCardNumber());
            this.addParam(params, "eyear", paymentRequest.getCreditCard().getExpiryYear());
            this.addParam(params, "emonth", paymentRequest.getCreditCard().getExpiryMonth());
            this.addParam(params, "cvc", paymentRequest.getCreditCard().getCvc());
            this.addParam(params, "cardholderName", paymentRequest.getCardholderName());
            this.addParam(params, "cardholderAddress", paymentRequest.getCardholderAddress());
            this.addParam(params, "issueNumber", paymentRequest.getIssueNumber());
            this.addParam(params, "startMonth", paymentRequest.getStartMonth());
            this.addParam(params, "startYear", paymentRequest.getStartYear());
        }
        if (paymentRequest.getAgreementConfig() != null) {
            this.addParam(params, "agreement[id]", paymentRequest.getAgreementConfig().getAgreementId());
            this.addParam(params, "agreement[type]", paymentRequest.getAgreementConfig().getAgreementType() != null ? paymentRequest.getAgreementConfig().getAgreementType().name() : null);
            this.addParam(params, "agreement[unscheduled_type]", paymentRequest.getAgreementConfig().getAgreementUnscheduledType() != null ? paymentRequest.getAgreementConfig().getAgreementUnscheduledType().name() : null);
            this.addParam(params, "agreement[expiry]", paymentRequest.getAgreementConfig().getAgreementExpiry() != null ? DateHelper.formatDate("yyyyMMdd", paymentRequest.getAgreementConfig().getAgreementExpiry()) : null);
            this.addParam(params, "agreement[frequency]", paymentRequest.getAgreementConfig().getAgreementFrequency());
            this.addParam(params, "agreement[next_charge_date]", paymentRequest.getAgreementConfig().getAgreementNextChargeDate() != null ? DateHelper.formatDate("yyyyMMdd", paymentRequest.getAgreementConfig().getAgreementNextChargeDate()) : null);
            this.addParam(params, "agreement[admin_url]", paymentRequest.getAgreementConfig().getAgreementAdminUrl());
            this.addParam(params, "agreement[retention_period]", paymentRequest.getAgreementConfig().getRetentionPeriod());
        }
        if (paymentRequest.getGiftCard() != null) {
            this.addParam(params, "giftcard[account_identifier]", paymentRequest.getGiftCard().getAccountIdentifier());
            this.addParam(params, "giftcard[account_authenticator]", paymentRequest.getGiftCard().getAccountAuthenticator());
            this.addParam(params, "giftcard[provider]", paymentRequest.getGiftCard().getProvider());
        } else {
            this.addParam(params, "giftcard[token]", paymentRequest.getGiftCardToken());
        }
        this.addParam(params, "payment_request_id", paymentRequest.getPaymentRequestId());
    }
}

