/*
 * Decompiled with CFR 0.152.
 */
package com.pensio.api.request;

import com.pensio.Amount;
import com.pensio.api.request.AgreementConfig;
import com.pensio.api.request.AgreementType;
import com.pensio.api.request.AuthType;
import com.pensio.api.request.CustomerInfo;
import com.pensio.api.request.OrderLine;
import com.pensio.api.request.PaymentInfos;
import com.pensio.api.request.PaymentRequestConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PaymentRequest<T extends PaymentRequest<T>> {
    protected String shopOrderId;
    protected String terminal;
    protected AuthType authType;
    protected String language;
    protected String creditCardToken;
    protected Amount amount;
    protected String cookie;
    protected String shippingMethod;
    protected Date customerCreateAt;
    private boolean usePayPass;
    private String giftCardToken;
    protected PaymentRequestConfig config;
    protected CustomerInfo customerInfo;
    private PaymentInfos paymentInfos = new PaymentInfos();
    private List<OrderLine> orderLines = new ArrayList<OrderLine>();
    @Deprecated
    protected AgreementType agreementType;
    protected AgreementConfig agreementConfig;

    public PaymentRequest() {
    }

    public PaymentRequest(String shopOrderId, String terminal, Amount amount) {
        this.shopOrderId = shopOrderId;
        this.terminal = terminal;
        this.amount = amount;
    }

    public String getShopOrderId() {
        return this.shopOrderId;
    }

    public T setShopOrderId(String shopOrderId) {
        this.shopOrderId = shopOrderId;
        return (T)this;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public T setTerminal(String terminal) {
        this.terminal = terminal;
        return (T)this;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public T setAuthType(AuthType authType) {
        this.authType = authType;
        return (T)this;
    }

    public String getLanguage() {
        return this.language;
    }

    public T setLanguage(String language) {
        this.language = language;
        return (T)this;
    }

    public String getCreditCardToken() {
        return this.creditCardToken;
    }

    public T setCreditCardToken(String creditCardToken) {
        this.creditCardToken = creditCardToken;
        return (T)this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public T setAmount(Amount amount) {
        this.amount = amount;
        return (T)this;
    }

    public String getCookie() {
        return this.cookie;
    }

    public T setCookie(String cookie) {
        this.cookie = cookie;
        return (T)this;
    }

    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public T setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
        return (T)this;
    }

    public Date getCustomerCreateAt() {
        return this.customerCreateAt;
    }

    public T setCustomerCreateAt(Date customerCreateAt) {
        this.customerCreateAt = customerCreateAt;
        return (T)this;
    }

    public PaymentRequestConfig getConfig() {
        return this.config;
    }

    public T setConfig(PaymentRequestConfig config) {
        this.config = config;
        return (T)this;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public T setCustomerInfo(CustomerInfo customerInfo) {
        this.customerInfo = customerInfo;
        return (T)this;
    }

    public PaymentInfos getPaymentInfos() {
        return this.paymentInfos;
    }

    public T addPaymentInfo(String key, String value) {
        this.paymentInfos.add(key, value);
        return (T)this;
    }

    public boolean getUsePayPass() {
        return this.usePayPass;
    }

    public T setUsePayPass(boolean usePayPass) {
        this.usePayPass = usePayPass;
        return (T)this;
    }

    public String getGiftCardToken() {
        return this.giftCardToken;
    }

    public T setGiftCardToken(String giftCardToken) {
        this.giftCardToken = giftCardToken;
        return (T)this;
    }

    public List<OrderLine> getOrderLines() {
        return this.orderLines;
    }

    public T setOrderLines(List<OrderLine> orderLines) {
        this.orderLines.clear();
        this.orderLines.addAll(orderLines);
        return (T)this;
    }

    @Deprecated
    public AgreementType getAgreementType() {
        return this.agreementType;
    }

    @Deprecated
    public T setAgreementType(AgreementType agreementType) {
        this.agreementType = agreementType;
        AgreementConfig agreementConfig = new AgreementConfig();
        agreementConfig.setAgreementType(AgreementType.unscheduled);
        this.setAgreementConfig(agreementConfig);
        return (T)this;
    }

    public AgreementConfig getAgreementConfig() {
        return this.agreementConfig;
    }

    public T setAgreementConfig(AgreementConfig agreementConfig) {
        this.agreementConfig = agreementConfig;
        return (T)this;
    }
}

