/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;

public class InvokeRequestMarshaller
implements Marshaller<Request<InvokeRequest>, InvokeRequest> {
    public Request<InvokeRequest> marshall(InvokeRequest invokeRequest) {
        if (invokeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)invokeRequest, "AWSLambda");
        String target = "AWSLambda.Invoke";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (invokeRequest.getInvocationType() != null) {
            request.addHeader("X-Amz-Invocation-Type", StringUtils.fromString((String)invokeRequest.getInvocationType()));
        }
        if (invokeRequest.getLogType() != null) {
            request.addHeader("X-Amz-Log-Type", StringUtils.fromString((String)invokeRequest.getLogType()));
        }
        if (invokeRequest.getClientContext() != null) {
            request.addHeader("X-Amz-Client-Context", StringUtils.fromString((String)invokeRequest.getClientContext()));
        }
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/invocations?Qualifier={Qualifier}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", invokeRequest.getFunctionName() == null ? "" : StringUtils.fromString((String)invokeRequest.getFunctionName()));
        uriResourcePath = uriResourcePath.replace("{Qualifier}", invokeRequest.getQualifier() == null ? "" : StringUtils.fromString((String)invokeRequest.getQualifier()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.addHeader("Content-Length", Integer.toString(invokeRequest.getPayload().remaining()));
        request.setContent(BinaryUtils.toStream((ByteBuffer)invokeRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

