/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.lambdainvoker;

import android.content.Context;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaDataBinder;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaInvocationHandler;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaJsonBinder;
import com.amazonaws.mobileconnectors.util.ClientContext;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.json.JSONObject;

public class LambdaInvokerFactory {
    private final AWSLambda lambda;
    private final ClientContext clientContext;

    public static Builder builder() {
        return new Builder();
    }

    public LambdaInvokerFactory(Context context, Regions region, AWSCredentialsProvider provider) {
        this(context, region, provider, new ClientConfiguration());
    }

    public LambdaInvokerFactory(Context context, Regions region, AWSCredentialsProvider provider, ClientConfiguration clientConfiguration) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider can't be null");
        }
        this.lambda = new AWSLambdaClient(provider, clientConfiguration);
        this.lambda.setRegion(Region.getRegion((Regions)region));
        this.clientContext = new ClientContext(context);
    }

    LambdaInvokerFactory(AWSLambda lambda, ClientContext clientContext) {
        this.lambda = lambda;
        this.clientContext = clientContext;
    }

    public <T> T build(Class<T> interfaceClass) {
        return this.build(interfaceClass, new LambdaJsonBinder());
    }

    public <T> T build(Class<T> interfaceClass, LambdaDataBinder binder) {
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LambdaInvocationHandler(this.lambda, binder, this.clientContext));
        return interfaceClass.cast(proxy);
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public static class Builder {
        private Context context;
        private Regions region;
        private AWSCredentialsProvider provider;
        private ClientConfiguration clientConfig;
        private AWSConfiguration awsConfig;
        private AWSLambda lambda;
        private ClientContext clientContext;

        protected Builder() {
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder region(Regions region) {
            this.region = region;
            return this;
        }

        public Builder credentialsProvider(AWSCredentialsProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder clientConfiguration(ClientConfiguration clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder clientContext(ClientContext clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public Builder lambdaClient(AWSLambda lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder awsConfiguration(AWSConfiguration awsConfig) {
            this.awsConfig = awsConfig;
            return this;
        }

        public LambdaInvokerFactory build() {
            if (this.clientConfig == null) {
                if (this.context == null) {
                    throw new IllegalArgumentException("Context or ClientContext are required please set using .context(context) or .clientContext(clientContext)");
                }
                this.clientContext = new ClientContext(this.context);
            }
            if (this.lambda == null) {
                if (this.provider == null) {
                    throw new IllegalArgumentException("AWSCredentialsProvider is required please set using .credentialsProvider(creds)");
                }
                if (this.clientConfig == null) {
                    this.clientConfig = new ClientConfiguration();
                }
            }
            if (this.awsConfig != null) {
                try {
                    if (this.clientConfig != null) {
                        String userAgent = this.clientConfig.getUserAgent();
                        if (userAgent == null || userAgent.trim().isEmpty()) {
                            this.clientConfig.setUserAgent(this.awsConfig.getUserAgent());
                        } else {
                            this.clientConfig.setUserAgent(userAgent + "/" + this.awsConfig.getUserAgent());
                        }
                    }
                    JSONObject lambdaConfig = this.awsConfig.optJsonObject("LambdaInvoker");
                    if (this.region != null) {
                        this.region = Regions.fromName((String)lambdaConfig.getString("Region"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read LambdaInvoker please check your setup or awsconfiguration.json file", e);
                }
            }
            if (this.lambda == null) {
                this.lambda = new AWSLambdaClient(this.provider, this.clientConfig);
            }
            if (this.region != null) {
                this.lambda.setRegion(Region.getRegion((Regions)this.region));
            }
            return new LambdaInvokerFactory(this.lambda, this.clientContext);
        }
    }
}

