/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.io.IOException;
import java.io.InputStream;

public class CryptoInputStream<K extends MasterKey<K>>
extends InputStream {
    private static final int MAX_READ_LEN = 4096;
    private byte[] outBytes_ = new byte[0];
    private int outStart_;
    private int outEnd_;
    private final InputStream inputStream_;
    private final MessageCryptoHandler cryptoHandler_;
    private boolean hasFinalCalled_;
    private boolean hasProcessBytesCalled_;

    CryptoInputStream(InputStream inputStream, MessageCryptoHandler cryptoHandler) {
        this.inputStream_ = Utils.assertNonNull(inputStream, "inputStream");
        this.cryptoHandler_ = Utils.assertNonNull(cryptoHandler, "cryptoHandler");
    }

    private int fillOutBytes() throws IOException, BadCiphertextException {
        int processedLen;
        byte[] inputStreamBytes = new byte[4096];
        int readLen = this.inputStream_.read(inputStreamBytes);
        this.outStart_ = 0;
        if (readLen < 0) {
            processedLen = -1;
            if (!this.hasFinalCalled_) {
                int outOffset = 0;
                int outLen = 0;
                if (!this.hasProcessBytesCalled_) {
                    this.outBytes_ = new byte[this.cryptoHandler_.estimateOutputSize(0)];
                    outLen += this.cryptoHandler_.processBytes(inputStreamBytes, 0, 0, this.outBytes_, outOffset).getBytesWritten();
                    outOffset += outLen;
                } else {
                    this.outBytes_ = new byte[this.cryptoHandler_.estimateFinalOutputSize()];
                }
                processedLen = outLen += this.cryptoHandler_.doFinal(this.outBytes_, outOffset);
                this.hasFinalCalled_ = true;
            }
        } else {
            this.outBytes_ = new byte[this.cryptoHandler_.estimatePartialOutputSize(readLen)];
            processedLen = this.cryptoHandler_.processBytes(inputStreamBytes, 0, readLen, this.outBytes_, this.outStart_).getBytesWritten();
            this.hasProcessBytesCalled_ = true;
        }
        this.outEnd_ = processedLen;
        return processedLen;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IllegalArgumentException, IOException, BadCiphertextException {
        Utils.assertNonNull(b, "b");
        if (len < 0 || off < 0) {
            throw new IllegalArgumentException(String.format("Invalid values for offset: %d and length: %d", off, len));
        }
        if (b.length == 0 || len == 0) {
            return 0;
        }
        if (this.outEnd_ - this.outStart_ <= 0) {
            int newBytesLen = 0;
            while (newBytesLen == 0) {
                newBytesLen = this.fillOutBytes();
            }
            if (newBytesLen < 0) {
                return -1;
            }
        }
        int copyLen = Math.min(this.outEnd_ - this.outStart_, len);
        System.arraycopy(this.outBytes_, this.outStart_, b, off, copyLen);
        this.outStart_ += copyLen;
        return copyLen;
    }

    @Override
    public int read(byte[] b) throws IllegalArgumentException, IOException, BadCiphertextException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException, BadCiphertextException {
        byte[] bArray = new byte[1];
        int result = 0;
        while (result == 0) {
            result = this.read(bArray, 0, 1);
        }
        if (result > 0) {
            return bArray[0] & 0xFF;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.inputStream_.close();
    }

    @Override
    public int available() throws IOException {
        return this.outBytes_.length + this.inputStream_.available();
    }

    public void setMaxInputLength(long size) {
        this.cryptoHandler_.setMaxInputLength(size);
    }

    public CryptoResult<CryptoInputStream<K>, K> getCryptoResult() throws BadCiphertextException, IOException {
        while (!this.cryptoHandler_.getHeaders().isComplete().booleanValue()) {
            if (this.fillOutBytes() != -1) continue;
            throw new BadCiphertextException("No CiphertextHeaders found.");
        }
        return new CryptoResult(this, this.cryptoHandler_.getMasterKeys(), this.cryptoHandler_.getHeaders(), this.cryptoHandler_.getEncryptionContext());
    }
}

