/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.utils.FunctionalUtils;
import com.amazonaws.util.ImmutableMapParameter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ModelClassGeneratorTasks
extends BaseGeneratorTasks {
    private final String modelClassDir;

    public ModelClassGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.modelClassDir = dependencies.getPathProvider().getModelDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting model classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerateShape((ShapeModel)e.getValue())).map(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private boolean shouldGenerateShape(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingModelClass()) {
            System.out.println("Skip generating class " + shapeModel.getShapeName());
            return false;
        }
        return true;
    }

    private GeneratorTask createTask(String javaShapeName, ShapeModel shapeModel) throws IOException {
        Metadata metadata = this.model.getMetadata();
        ImmutableMapParameter dataModel = ImmutableMapParameter.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shape", (Object)shapeModel).put((Object)"metadata", (Object)metadata).put((Object)"baseClassFqcn", (Object)this.getModelBaseClassFqcn(shapeModel.getShapeType())).put((Object)"customConfig", (Object)this.model.getCustomizationConfig()).put((Object)"shouldGenerateSdkRequestConfigSetter", (Object)this.shouldGenerateSdkRequestConfigSetter(shapeModel)).build();
        return new FreemarkerGeneratorTask(this.modelClassDir, javaShapeName, this.freemarker.getShapeTemplate(shapeModel), dataModel);
    }

    private boolean shouldGenerateSdkRequestConfigSetter(ShapeModel shape) {
        return this.model.getMetadata().getProtocol() == Protocol.API_GATEWAY && shape.getShapeType() == ShapeType.Request;
    }

    private String getModelBaseClassFqcn(ShapeType shapeType) {
        switch (shapeType) {
            case Exception: {
                return this.model.getSdkModeledExceptionBaseFqcn();
            }
            case Response: {
                return this.model.getSdkBaseResponseFqcn();
            }
            case Request: {
                return this.model.getMetadata().getRequestBaseFqcn();
            }
        }
        return null;
    }
}

