/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.util.json.SdkJsonGenerator;

public class TriggerConfigJsonMarshaller {
    private static TriggerConfigJsonMarshaller instance;

    public void marshall(TriggerConfig triggerConfig, SdkJsonGenerator jsonGenerator) {
        if (triggerConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList triggerEventsList;
            jsonGenerator.writeStartObject();
            if (triggerConfig.getTriggerName() != null) {
                jsonGenerator.writeFieldName("triggerName").writeValue(triggerConfig.getTriggerName());
            }
            if (triggerConfig.getTriggerTargetArn() != null) {
                jsonGenerator.writeFieldName("triggerTargetArn").writeValue(triggerConfig.getTriggerTargetArn());
            }
            if (!(triggerEventsList = (SdkInternalList)triggerConfig.getTriggerEvents()).isEmpty() || !triggerEventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("triggerEvents");
                jsonGenerator.writeStartArray();
                for (String triggerEventsListValue : triggerEventsList) {
                    if (triggerEventsListValue == null) continue;
                    jsonGenerator.writeValue(triggerEventsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TriggerConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TriggerConfigJsonMarshaller();
        }
        return instance;
    }
}

