/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.services.codedeploy.model.UpdateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.transform.AlarmConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.AutoRollbackConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TriggerConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateDeploymentGroupRequestMarshaller
implements Marshaller<Request<UpdateDeploymentGroupRequest>, UpdateDeploymentGroupRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDeploymentGroupRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateDeploymentGroupRequest> marshall(UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        if (updateDeploymentGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDeploymentGroupRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.UpdateDeploymentGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList triggerConfigurationsList;
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateDeploymentGroupRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(updateDeploymentGroupRequest.getApplicationName());
            }
            if (updateDeploymentGroupRequest.getCurrentDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("currentDeploymentGroupName").writeValue(updateDeploymentGroupRequest.getCurrentDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getNewDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("newDeploymentGroupName").writeValue(updateDeploymentGroupRequest.getNewDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(updateDeploymentGroupRequest.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)updateDeploymentGroupRequest.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ec2TagFilters");
                jsonGenerator.writeStartArray();
                for (Object ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall((EC2TagFilter)ec2TagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)updateDeploymentGroupRequest.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("onPremisesInstanceTagFilters");
                jsonGenerator.writeStartArray();
                for (Object onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall((TagFilter)onPremisesInstanceTagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)updateDeploymentGroupRequest.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (Object autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonGenerator.writeValue((String)autoScalingGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateDeploymentGroupRequest.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("serviceRoleArn").writeValue(updateDeploymentGroupRequest.getServiceRoleArn());
            }
            if (!(triggerConfigurationsList = (SdkInternalList)updateDeploymentGroupRequest.getTriggerConfigurations()).isEmpty() || !triggerConfigurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("triggerConfigurations");
                jsonGenerator.writeStartArray();
                for (TriggerConfig triggerConfigurationsListValue : triggerConfigurationsList) {
                    if (triggerConfigurationsListValue == null) continue;
                    TriggerConfigJsonMarshaller.getInstance().marshall(triggerConfigurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateDeploymentGroupRequest.getAlarmConfiguration() != null) {
                jsonGenerator.writeFieldName("alarmConfiguration");
                AlarmConfigurationJsonMarshaller.getInstance().marshall(updateDeploymentGroupRequest.getAlarmConfiguration(), jsonGenerator);
            }
            if (updateDeploymentGroupRequest.getAutoRollbackConfiguration() != null) {
                jsonGenerator.writeFieldName("autoRollbackConfiguration");
                AutoRollbackConfigurationJsonMarshaller.getInstance().marshall(updateDeploymentGroupRequest.getAutoRollbackConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

