/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.InstanceStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeploymentInstancesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String deploymentId;
    private String nextToken;
    private ListWithAutoConstructFlag<String> instanceStatusFilter;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public ListDeploymentInstancesRequest withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDeploymentInstancesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public List<String> getInstanceStatusFilter() {
        if (this.instanceStatusFilter == null) {
            this.instanceStatusFilter = new ListWithAutoConstructFlag();
            this.instanceStatusFilter.setAutoConstruct(true);
        }
        return this.instanceStatusFilter;
    }

    public void setInstanceStatusFilter(Collection<String> instanceStatusFilter) {
        if (instanceStatusFilter == null) {
            this.instanceStatusFilter = null;
            return;
        }
        ListWithAutoConstructFlag instanceStatusFilterCopy = new ListWithAutoConstructFlag(instanceStatusFilter.size());
        instanceStatusFilterCopy.addAll(instanceStatusFilter);
        this.instanceStatusFilter = instanceStatusFilterCopy;
    }

    public ListDeploymentInstancesRequest withInstanceStatusFilter(String ... instanceStatusFilter) {
        if (this.getInstanceStatusFilter() == null) {
            this.setInstanceStatusFilter(new ArrayList<String>(instanceStatusFilter.length));
        }
        for (String value : instanceStatusFilter) {
            this.getInstanceStatusFilter().add(value);
        }
        return this;
    }

    public ListDeploymentInstancesRequest withInstanceStatusFilter(Collection<String> instanceStatusFilter) {
        if (instanceStatusFilter == null) {
            this.instanceStatusFilter = null;
        } else {
            ListWithAutoConstructFlag instanceStatusFilterCopy = new ListWithAutoConstructFlag(instanceStatusFilter.size());
            instanceStatusFilterCopy.addAll(instanceStatusFilter);
            this.instanceStatusFilter = instanceStatusFilterCopy;
        }
        return this;
    }

    public ListDeploymentInstancesRequest withInstanceStatusFilter(InstanceStatus ... instanceStatusFilter) {
        ArrayList<String> instanceStatusFilterCopy = new ArrayList<String>(instanceStatusFilter.length);
        for (InstanceStatus member : instanceStatusFilter) {
            instanceStatusFilterCopy.add(member.toString());
        }
        if (this.getInstanceStatusFilter() == null) {
            this.setInstanceStatusFilter(instanceStatusFilterCopy);
        } else {
            this.getInstanceStatusFilter().addAll(instanceStatusFilterCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: " + this.getDeploymentId() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getInstanceStatusFilter() != null) {
            sb.append("InstanceStatusFilter: " + this.getInstanceStatusFilter());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceStatusFilter() == null ? 0 : this.getInstanceStatusFilter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesRequest)) {
            return false;
        }
        ListDeploymentInstancesRequest other = (ListDeploymentInstancesRequest)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getInstanceStatusFilter() == null ^ this.getInstanceStatusFilter() == null) {
            return false;
        }
        return other.getInstanceStatusFilter() == null || other.getInstanceStatusFilter().equals(this.getInstanceStatusFilter());
    }
}

