/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import com.amazonaws.services.elastictranscoder.model.transform.HlsContentProtectionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PlayReadyDrmJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PlaylistJsonMarshaller {
    private static PlaylistJsonMarshaller instance;

    public void marshall(Playlist playlist, JSONWriter jsonWriter) {
        if (playlist == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList outputKeysList;
            jsonWriter.object();
            if (playlist.getName() != null) {
                jsonWriter.key("Name").value((Object)playlist.getName());
            }
            if (playlist.getFormat() != null) {
                jsonWriter.key("Format").value((Object)playlist.getFormat());
            }
            if (!(outputKeysList = (SdkInternalList)playlist.getOutputKeys()).isEmpty() || !outputKeysList.isAutoConstruct()) {
                jsonWriter.key("OutputKeys");
                jsonWriter.array();
                for (String outputKeysListValue : outputKeysList) {
                    if (outputKeysListValue == null) continue;
                    jsonWriter.value((Object)outputKeysListValue);
                }
                jsonWriter.endArray();
            }
            if (playlist.getHlsContentProtection() != null) {
                jsonWriter.key("HlsContentProtection");
                HlsContentProtectionJsonMarshaller.getInstance().marshall(playlist.getHlsContentProtection(), jsonWriter);
            }
            if (playlist.getPlayReadyDrm() != null) {
                jsonWriter.key("PlayReadyDrm");
                PlayReadyDrmJsonMarshaller.getInstance().marshall(playlist.getPlayReadyDrm(), jsonWriter);
            }
            if (playlist.getStatus() != null) {
                jsonWriter.key("Status").value((Object)playlist.getStatus());
            }
            if (playlist.getStatusDetail() != null) {
                jsonWriter.key("StatusDetail").value((Object)playlist.getStatusDetail());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PlaylistJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PlaylistJsonMarshaller();
        }
        return instance;
    }
}

