/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lambda.model;

/**
 * <p/>
 */
public class TooManyRequestsException extends com.amazonaws.services.lambda.model.AWSLambdaException {
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The number of seconds the caller should wait before retrying.
     * </p>
     */
    private String retryAfterSeconds;

    private String type;

    private String reason;

    /**
     * Constructs a new TooManyRequestsException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public TooManyRequestsException(String message) {
        super(message);
    }

    /**
     * <p>
     * The number of seconds the caller should wait before retrying.
     * </p>
     * 
     * @param retryAfterSeconds
     *        The number of seconds the caller should wait before retrying.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Retry-After")
    public void setRetryAfterSeconds(String retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
    }

    /**
     * <p>
     * The number of seconds the caller should wait before retrying.
     * </p>
     * 
     * @return The number of seconds the caller should wait before retrying.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Retry-After")
    public String getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    /**
     * <p>
     * The number of seconds the caller should wait before retrying.
     * </p>
     * 
     * @param retryAfterSeconds
     *        The number of seconds the caller should wait before retrying.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TooManyRequestsException withRetryAfterSeconds(String retryAfterSeconds) {
        setRetryAfterSeconds(retryAfterSeconds);
        return this;
    }

    /**
     * @param type
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Type")
    public String getType() {
        return this.type;
    }

    /**
     * @param type
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TooManyRequestsException withType(String type) {
        setType(type);
        return this;
    }

    /**
     * @param reason
     * @see ThrottleReason
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * @return
     * @see ThrottleReason
     */

    @com.fasterxml.jackson.annotation.JsonProperty("Reason")
    public String getReason() {
        return this.reason;
    }

    /**
     * @param reason
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ThrottleReason
     */

    public TooManyRequestsException withReason(String reason) {
        setReason(reason);
        return this;
    }

    /**
     * @param reason
     * @see ThrottleReason
     */

    public void setReason(ThrottleReason reason) {
        this.reason = reason.toString();
    }

    /**
     * @param reason
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ThrottleReason
     */

    public TooManyRequestsException withReason(ThrottleReason reason) {
        setReason(reason);
        return this;
    }

}
