/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lambda.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Cors" target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Cors implements Serializable, Cloneable, StructuredPojo {

    private Boolean allowCredentials;

    private com.amazonaws.internal.SdkInternalList<String> allowHeaders;

    private com.amazonaws.internal.SdkInternalList<String> allowMethods;

    private com.amazonaws.internal.SdkInternalList<String> allowOrigins;

    private com.amazonaws.internal.SdkInternalList<String> exposeHeaders;

    private Integer maxAge;

    /**
     * @param allowCredentials
     */

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    /**
     * @return
     */

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    /**
     * @param allowCredentials
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowCredentials(Boolean allowCredentials) {
        setAllowCredentials(allowCredentials);
        return this;
    }

    /**
     * @return
     */

    public Boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    /**
     * @return
     */

    public java.util.List<String> getAllowHeaders() {
        if (allowHeaders == null) {
            allowHeaders = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return allowHeaders;
    }

    /**
     * @param allowHeaders
     */

    public void setAllowHeaders(java.util.Collection<String> allowHeaders) {
        if (allowHeaders == null) {
            this.allowHeaders = null;
            return;
        }

        this.allowHeaders = new com.amazonaws.internal.SdkInternalList<String>(allowHeaders);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAllowHeaders(java.util.Collection)} or {@link #withAllowHeaders(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param allowHeaders
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowHeaders(String... allowHeaders) {
        if (this.allowHeaders == null) {
            setAllowHeaders(new com.amazonaws.internal.SdkInternalList<String>(allowHeaders.length));
        }
        for (String ele : allowHeaders) {
            this.allowHeaders.add(ele);
        }
        return this;
    }

    /**
     * @param allowHeaders
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowHeaders(java.util.Collection<String> allowHeaders) {
        setAllowHeaders(allowHeaders);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<String> getAllowMethods() {
        if (allowMethods == null) {
            allowMethods = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return allowMethods;
    }

    /**
     * @param allowMethods
     */

    public void setAllowMethods(java.util.Collection<String> allowMethods) {
        if (allowMethods == null) {
            this.allowMethods = null;
            return;
        }

        this.allowMethods = new com.amazonaws.internal.SdkInternalList<String>(allowMethods);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAllowMethods(java.util.Collection)} or {@link #withAllowMethods(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param allowMethods
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowMethods(String... allowMethods) {
        if (this.allowMethods == null) {
            setAllowMethods(new com.amazonaws.internal.SdkInternalList<String>(allowMethods.length));
        }
        for (String ele : allowMethods) {
            this.allowMethods.add(ele);
        }
        return this;
    }

    /**
     * @param allowMethods
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowMethods(java.util.Collection<String> allowMethods) {
        setAllowMethods(allowMethods);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<String> getAllowOrigins() {
        if (allowOrigins == null) {
            allowOrigins = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return allowOrigins;
    }

    /**
     * @param allowOrigins
     */

    public void setAllowOrigins(java.util.Collection<String> allowOrigins) {
        if (allowOrigins == null) {
            this.allowOrigins = null;
            return;
        }

        this.allowOrigins = new com.amazonaws.internal.SdkInternalList<String>(allowOrigins);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAllowOrigins(java.util.Collection)} or {@link #withAllowOrigins(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param allowOrigins
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowOrigins(String... allowOrigins) {
        if (this.allowOrigins == null) {
            setAllowOrigins(new com.amazonaws.internal.SdkInternalList<String>(allowOrigins.length));
        }
        for (String ele : allowOrigins) {
            this.allowOrigins.add(ele);
        }
        return this;
    }

    /**
     * @param allowOrigins
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withAllowOrigins(java.util.Collection<String> allowOrigins) {
        setAllowOrigins(allowOrigins);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<String> getExposeHeaders() {
        if (exposeHeaders == null) {
            exposeHeaders = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return exposeHeaders;
    }

    /**
     * @param exposeHeaders
     */

    public void setExposeHeaders(java.util.Collection<String> exposeHeaders) {
        if (exposeHeaders == null) {
            this.exposeHeaders = null;
            return;
        }

        this.exposeHeaders = new com.amazonaws.internal.SdkInternalList<String>(exposeHeaders);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setExposeHeaders(java.util.Collection)} or {@link #withExposeHeaders(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param exposeHeaders
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withExposeHeaders(String... exposeHeaders) {
        if (this.exposeHeaders == null) {
            setExposeHeaders(new com.amazonaws.internal.SdkInternalList<String>(exposeHeaders.length));
        }
        for (String ele : exposeHeaders) {
            this.exposeHeaders.add(ele);
        }
        return this;
    }

    /**
     * @param exposeHeaders
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withExposeHeaders(java.util.Collection<String> exposeHeaders) {
        setExposeHeaders(exposeHeaders);
        return this;
    }

    /**
     * @param maxAge
     */

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    /**
     * @return
     */

    public Integer getMaxAge() {
        return this.maxAge;
    }

    /**
     * @param maxAge
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Cors withMaxAge(Integer maxAge) {
        setMaxAge(maxAge);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAllowCredentials() != null)
            sb.append("AllowCredentials: ").append(getAllowCredentials()).append(",");
        if (getAllowHeaders() != null)
            sb.append("AllowHeaders: ").append(getAllowHeaders()).append(",");
        if (getAllowMethods() != null)
            sb.append("AllowMethods: ").append(getAllowMethods()).append(",");
        if (getAllowOrigins() != null)
            sb.append("AllowOrigins: ").append(getAllowOrigins()).append(",");
        if (getExposeHeaders() != null)
            sb.append("ExposeHeaders: ").append(getExposeHeaders()).append(",");
        if (getMaxAge() != null)
            sb.append("MaxAge: ").append(getMaxAge());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Cors == false)
            return false;
        Cors other = (Cors) obj;
        if (other.getAllowCredentials() == null ^ this.getAllowCredentials() == null)
            return false;
        if (other.getAllowCredentials() != null && other.getAllowCredentials().equals(this.getAllowCredentials()) == false)
            return false;
        if (other.getAllowHeaders() == null ^ this.getAllowHeaders() == null)
            return false;
        if (other.getAllowHeaders() != null && other.getAllowHeaders().equals(this.getAllowHeaders()) == false)
            return false;
        if (other.getAllowMethods() == null ^ this.getAllowMethods() == null)
            return false;
        if (other.getAllowMethods() != null && other.getAllowMethods().equals(this.getAllowMethods()) == false)
            return false;
        if (other.getAllowOrigins() == null ^ this.getAllowOrigins() == null)
            return false;
        if (other.getAllowOrigins() != null && other.getAllowOrigins().equals(this.getAllowOrigins()) == false)
            return false;
        if (other.getExposeHeaders() == null ^ this.getExposeHeaders() == null)
            return false;
        if (other.getExposeHeaders() != null && other.getExposeHeaders().equals(this.getExposeHeaders()) == false)
            return false;
        if (other.getMaxAge() == null ^ this.getMaxAge() == null)
            return false;
        if (other.getMaxAge() != null && other.getMaxAge().equals(this.getMaxAge()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAllowCredentials() == null) ? 0 : getAllowCredentials().hashCode());
        hashCode = prime * hashCode + ((getAllowHeaders() == null) ? 0 : getAllowHeaders().hashCode());
        hashCode = prime * hashCode + ((getAllowMethods() == null) ? 0 : getAllowMethods().hashCode());
        hashCode = prime * hashCode + ((getAllowOrigins() == null) ? 0 : getAllowOrigins().hashCode());
        hashCode = prime * hashCode + ((getExposeHeaders() == null) ? 0 : getExposeHeaders().hashCode());
        hashCode = prime * hashCode + ((getMaxAge() == null) ? 0 : getMaxAge().hashCode());
        return hashCode;
    }

    @Override
    public Cors clone() {
        try {
            return (Cors) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lambda.model.transform.CorsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
