/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetConnectionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String globalNetworkId;
    private List<String> connectionIds;
    private String deviceId;
    private Integer maxResults;
    private String nextToken;

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public GetConnectionsRequest withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public List<String> getConnectionIds() {
        return this.connectionIds;
    }

    public void setConnectionIds(Collection<String> connectionIds) {
        if (connectionIds == null) {
            this.connectionIds = null;
            return;
        }
        this.connectionIds = new ArrayList<String>(connectionIds);
    }

    public GetConnectionsRequest withConnectionIds(String ... connectionIds) {
        if (this.connectionIds == null) {
            this.setConnectionIds(new ArrayList<String>(connectionIds.length));
        }
        for (String ele : connectionIds) {
            this.connectionIds.add(ele);
        }
        return this;
    }

    public GetConnectionsRequest withConnectionIds(Collection<String> connectionIds) {
        this.setConnectionIds(connectionIds);
        return this;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public GetConnectionsRequest withDeviceId(String deviceId) {
        this.setDeviceId(deviceId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetConnectionsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetConnectionsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getConnectionIds() != null) {
            sb.append("ConnectionIds: ").append(this.getConnectionIds()).append(",");
        }
        if (this.getDeviceId() != null) {
            sb.append("DeviceId: ").append(this.getDeviceId()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsRequest)) {
            return false;
        }
        GetConnectionsRequest other = (GetConnectionsRequest)obj;
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getConnectionIds() == null ^ this.getConnectionIds() == null) {
            return false;
        }
        if (other.getConnectionIds() != null && !other.getConnectionIds().equals(this.getConnectionIds())) {
            return false;
        }
        if (other.getDeviceId() == null ^ this.getDeviceId() == null) {
            return false;
        }
        if (other.getDeviceId() != null && !other.getDeviceId().equals(this.getDeviceId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionIds() == null ? 0 : this.getConnectionIds().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceId() == null ? 0 : this.getDeviceId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetConnectionsRequest clone() {
        return (GetConnectionsRequest)super.clone();
    }
}

