/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples.util;

import com.amazonaws.codesamples.exception.SampleRetrievalException;

public class ValidationUtils {
    public static String assertInputNotEmpty(String input, String message) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return input;
    }

    public static String assertResultNotEmpty(String result, String serviceName, String sampleId, String message) {
        if (result == null || result.isEmpty()) {
            throw new SampleRetrievalException(message, serviceName, sampleId);
        }
        return result;
    }

    public static boolean areNullOrEmpty(String ... strings) {
        for (String str : strings) {
            if (!ValidationUtils.isNullOrEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

