/**
 * Copyright 2013 Huining (Thomas) Feng (tfeng@berkeley.edu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bacoder.parser.java.api;

import java.util.Collections;
import java.util.List;

import com.bacoder.parser.core.Visitors;

public class ClassInstantiation extends Invocation implements ExpressionInScope {

  private List<ClassMemberDeclaration> memberDeclarations = Collections.emptyList();

  private InstantiableType type;

  public List<ClassMemberDeclaration> getMemberDeclarations() {
    return memberDeclarations;
  }

  public InstantiableType getType() {
    return type;
  }

  public void setMemberDeclarations(List<ClassMemberDeclaration> memberDeclarations) {
    this.memberDeclarations = memberDeclarations;
  }

  public void setType(InstantiableType type) {
    this.type = type;
  }

  @Override
  protected void visitChildren(Visitors visitors) {
    super.visitChildren(visitors);
    for (ClassMemberDeclaration memberDeclaration : getMemberDeclarations()) {
      memberDeclaration.visit(visitors);
    }
  }

  @Override
  protected void visitName(Visitors visitors) {
    if (type != null) {
      type.visit(visitors);
    }
  }
}
