/**
 * Copyright 2013 Huining (Thomas) Feng (tfeng@berkeley.edu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bacoder.parser.java.api;

import com.bacoder.parser.core.Visitor;

public class GenericVisitor implements Visitor<JavaNode> {

  public void after(Annotation annotation) {
  }

  public void after(AnnotationArrayInitializer annotationArrayInitializer) {
  }

  public void after(AnnotationDeclaration annotationDeclaration) {
  }

  public void after(AnnotationMethodDeclaration annotationMethodDeclaration) {
  }

  public void after(ArrayAccess arrayAccess) {
  }

  public void after(ArrayCreation arrayCreation) {
  }

  public void after(ArrayCreationDimension arrayCreationDimension) {
  }

  public void after(ArrayInitializer arrayInitializer) {
  }

  public void after(AssertStatement assertStatement) {
  }

  public void after(Block block) {
  }

  public void after(BlockDeclaration blockDeclaration) {
  }

  public void after(BreakStatement breakStatement) {
  }

  public void after(CatchClause catchClause) {
  }

  public void after(ClassDeclaration classDeclaration) {
  }

  public void after(ClassExpression classExpression) {
  }

  public void after(ClassInstantiation classInstantiation) {
  }

  public void after(ClassMethodDeclaration classMethodDeclaration) {
  }

  public void after(ClassOrInterfaceType classOrInterfaceType) {
  }

  public void after(CompilationUnit compilationUnit) {
  }

  public void after(ConstDeclaration constDeclaration) {
  }

  public void after(ConstructorDeclaration constructorDeclaration) {
  }

  public void after(ContinueStatement continueStatement) {
  }

  public void after(DefaultSwitchLabel defaultSwitchLabel) {
  }

  public void after(DoWhileStatement doWhileStatement) {
  }

  public void after(EnumConstant enumConstant) {
  }

  public void after(EnumDeclaration enumDeclaration) {
  }

  public void after(ExpressionStatement expressionStatement) {
  }

  public void after(FieldDeclaration fieldDeclaration) {
  }

  public void after(ForEachControl forEachControl) {
  }

  public void after(FormalParameter formalParameter) {
  }

  public void after(ForStatement forStatement) {
  }

  public void after(GeneralInvocation generalInvocation) {
  }

  public void after(Identifier identifier) {
  }

  public void after(IdentifierWithTypeArguments identifierWithTypeArguments) {
  }

  public void after(IfStatement ifStatement) {
  }

  public void after(ImportDeclaration importDeclaration) {
  }

  public void after(InfixExpression infixExpression) {
  }

  public void after(InstanceOf instanceOf) {
  }

  public void after(InterfaceDeclaration interfaceDeclaration) {
  }

  public void after(InterfaceMethodDeclaration interfaceMethodDeclaration) {
  }

  public void after(Literal literal) {
  }

  public void after(LocalVariableDeclaration localVariableDeclaration) {
  }

  public void after(LoopControl loopControl) {
  }

  public void after(MethodInvocation methodInvocation) {
  }

  public void after(NameValuePair nameValuePair) {
  }

  public void after(PackageDeclaration packageDeclaration) {
  }

  public void after(PostfixExpression postfixExpression) {
  }

  public void after(PrefixExpression prefixExpression) {
  }

  public void after(PrimitiveType primitiveType) {
  }

  public void after(QualifiedName qualifiedName) {
  }

  public void after(Resource resource) {
  }

  public void after(ReturnStatement returnStatement) {
  }

  public void after(ScopedExpression scopedExpression) {
  }

  public void after(SuperExpression superExpression) {
  }

  public void after(SuperInvocation superInvocation) {
  }

  public void after(SwitchBlock switchBlock) {
  }

  public void after(SwitchStatement switchStatement) {
  }

  public void after(SynchronizedStatement synchronizedStatement) {
  }

  public void after(TernaryExpression ternaryExpression) {
  }

  public void after(ThisExpression thisExpression) {
  }

  public void after(ThisInvocation thisInvocation) {
  }

  public void after(ThrowStatement throwStatement) {
  }

  public void after(TryStatement tryStatement) {
  }

  public void after(TypeCast typeCast) {
  }

  public void after(TypeParameter typeParameter) {
  }

  public void after(TypeWithArguments typeWithArguments) {
  }

  public void after(VariableDeclaration variableDeclaration) {
  }

  public void after(VoidType voidType) {
  }

  public void after(WhileStatement whileStatement) {
  }

  public void after(WildcardTypeArgument wildcardTypeArgument) {
  }

  public void before(Annotation annotation) {
  }

  public void before(AnnotationArrayInitializer annotationArrayInitializer) {
  }

  public void before(AnnotationDeclaration annotationDeclaration) {
  }

  public void before(AnnotationMethodDeclaration annotationMethodDeclaration) {
  }

  public void before(ArrayAccess arrayAccess) {
  }

  public void before(ArrayCreation arrayCreation) {
  }

  public void before(ArrayCreationDimension arrayCreationDimension) {
  }

  public void before(ArrayInitializer arrayInitializer) {
  }

  public void before(AssertStatement assertStatement) {
  }

  public void before(Block block) {
  }

  public void before(BlockDeclaration blockDeclaration) {
  }

  public void before(BreakStatement breakStatement) {
  }

  public void before(CatchClause catchClause) {
  }

  public void before(ClassDeclaration classDeclaration) {
  }

  public void before(ClassExpression classExpression) {
  }

  public void before(ClassInstantiation classInstantiation) {
  }

  public void before(ClassMethodDeclaration classMethodDeclaration) {
  }

  public void before(ClassOrInterfaceType classOrInterfaceType) {
  }

  public void before(CompilationUnit compilationUnit) {
  }

  public void before(ConstDeclaration constDeclaration) {
  }

  public void before(ConstructorDeclaration constructorDeclaration) {
  }

  public void before(ContinueStatement continueStatement) {
  }

  public void before(DefaultSwitchLabel defaultSwitchLabel) {
  }

  public void before(DoWhileStatement doWhileStatement) {
  }

  public void before(EnumConstant enumConstant) {
  }

  public void before(EnumDeclaration enumDeclaration) {
  }

  public void before(ExpressionStatement expressionStatement) {
  }

  public void before(FieldDeclaration fieldDeclaration) {
  }

  public void before(ForEachControl forEachControl) {
  }

  public void before(FormalParameter formalParameter) {
  }

  public void before(ForStatement forStatement) {
  }

  public void before(GeneralInvocation generalInvocation) {
  }

  public void before(Identifier identifier) {
  }

  public void before(IdentifierWithTypeArguments identifierWithTypeArguments) {
  }

  public void before(IfStatement ifStatement) {
  }

  public void before(ImportDeclaration importDeclaration) {
  }

  public void before(InfixExpression infixExpression) {
  }

  public void before(InstanceOf instanceOf) {
  }

  public void before(InterfaceDeclaration interfaceDeclaration) {
  }

  public void before(InterfaceMethodDeclaration interfaceMethodDeclaration) {
  }

  public void before(Literal literal) {
  }

  public void before(LocalVariableDeclaration localVariableDeclaration) {
  }

  public void before(LoopControl loopControl) {
  }

  public void before(MethodInvocation methodInvocation) {
  }

  public void before(NameValuePair nameValuePair) {
  }

  public void before(PackageDeclaration packageDeclaration) {
  }

  public void before(PostfixExpression postfixExpression) {
  }

  public void before(PrefixExpression prefixExpression) {
  }

  public void before(PrimitiveType primitiveType) {
  }

  public void before(QualifiedName qualifiedName) {
  }

  public void before(Resource resource) {
  }

  public void before(ReturnStatement returnStatement) {
  }

  public void before(ScopedExpression scopedExpression) {
  }

  public void before(SuperExpression superExpression) {
  }

  public void before(SuperInvocation superInvocation) {
  }

  public void before(SwitchBlock switchBlock) {
  }

  public void before(SwitchStatement switchStatement) {
  }

  public void before(SynchronizedStatement synchronizedStatement) {
  }

  public void before(TernaryExpression ternaryExpression) {
  }

  public void before(ThisExpression thisExpression) {
  }

  public void before(ThisInvocation thisInvocation) {
  }

  public void before(ThrowStatement throwStatement) {
  }

  public void before(TryStatement tryStatement) {
  }

  public void before(TypeCast typeCast) {
  }

  public void before(TypeParameter typeParameter) {
  }

  public void before(TypeWithArguments typeWithArguments) {
  }

  public void before(VariableDeclaration variableDeclaration) {
  }

  public void before(VoidType voidType) {
  }

  public void before(WhileStatement whileStatement) {
  }

  public void before(WildcardTypeArgument wildcardTypeArgument) {
  }

  @Override
  public void visitAfter(JavaNode node) {
    if (node instanceof Annotation) {
      after((Annotation) node);
    } else if (node instanceof AnnotationArrayInitializer) {
      after((AnnotationArrayInitializer) node);
    } else if (node instanceof AnnotationDeclaration) {
      after((AnnotationDeclaration) node);
    } else if (node instanceof AnnotationMethodDeclaration) {
      after((AnnotationMethodDeclaration) node);
    } else if (node instanceof ArrayAccess) {
      after((ArrayAccess) node);
    } else if (node instanceof ArrayCreation) {
      after((ArrayCreation) node);
    } else if (node instanceof ArrayCreationDimension) {
      after((ArrayCreationDimension) node);
    } else if (node instanceof ArrayInitializer) {
      after((ArrayInitializer) node);
    } else if (node instanceof AssertStatement) {
      after((AssertStatement) node);
    } else if (node instanceof Block) {
      after((Block) node);
    } else if (node instanceof BlockDeclaration) {
      after((BlockDeclaration) node);
    } else if (node instanceof BreakStatement) {
      after((BreakStatement) node);
    } else if (node instanceof CatchClause) {
      after((CatchClause) node);
    } else if (node instanceof ClassDeclaration) {
      after((ClassDeclaration) node);
    } else if (node instanceof ClassExpression) {
      after((ClassExpression) node);
    } else if (node instanceof ClassInstantiation) {
      after((ClassInstantiation) node);
    } else if (node instanceof ClassMethodDeclaration) {
      after((ClassMethodDeclaration) node);
    } else if (node instanceof ClassOrInterfaceType) {
      after((ClassOrInterfaceType) node);
    } else if (node instanceof CompilationUnit) {
      after((CompilationUnit) node);
    } else if (node instanceof ConstDeclaration) {
      after((ConstDeclaration) node);
    } else if (node instanceof ConstructorDeclaration) {
      after((ConstructorDeclaration) node);
    } else if (node instanceof ContinueStatement) {
      after((ContinueStatement) node);
    } else if (node instanceof DefaultSwitchLabel) {
      after((DefaultSwitchLabel) node);
    } else if (node instanceof DoWhileStatement) {
      after((DoWhileStatement) node);
    } else if (node instanceof EnumConstant) {
      after((EnumConstant) node);
    } else if (node instanceof EnumDeclaration) {
      after((EnumDeclaration) node);
    } else if (node instanceof ExpressionStatement) {
      after((ExpressionStatement) node);
    } else if (node instanceof FieldDeclaration) {
      after((FieldDeclaration) node);
    } else if (node instanceof ForEachControl) {
      after((ForEachControl) node);
    } else if (node instanceof ForStatement) {
      after((ForStatement) node);
    } else if (node instanceof FormalParameter) {
      after((FormalParameter) node);
    } else if (node instanceof GeneralInvocation) {
      after((GeneralInvocation) node);
    } else if (node instanceof Identifier) {
      after((Identifier) node);
    } else if (node instanceof IdentifierWithTypeArguments) {
      after((IdentifierWithTypeArguments) node);
    } else if (node instanceof IfStatement) {
      after((IfStatement) node);
    } else if (node instanceof ImportDeclaration) {
      after((ImportDeclaration) node);
    } else if (node instanceof InfixExpression) {
      after((InfixExpression) node);
    } else if (node instanceof InstanceOf) {
      after((InstanceOf) node);
    } else if (node instanceof InterfaceDeclaration) {
      after((InterfaceDeclaration) node);
    } else if (node instanceof InterfaceMethodDeclaration) {
      after((InterfaceMethodDeclaration) node);
    } else if (node instanceof Literal) {
      after((Literal) node);
    } else if (node instanceof LocalVariableDeclaration) {
      after((LocalVariableDeclaration) node);
    } else if (node instanceof LoopControl) {
      after((LoopControl) node);
    } else if (node instanceof MethodInvocation) {
      after((MethodInvocation) node);
    } else if (node instanceof NameValuePair) {
      after((NameValuePair) node);
    } else if (node instanceof PackageDeclaration) {
      after((PackageDeclaration) node);
    } else if (node instanceof PostfixExpression) {
      after((PostfixExpression) node);
    } else if (node instanceof PrefixExpression) {
      after((PrefixExpression) node);
    } else if (node instanceof PrimitiveType) {
      after((PrimitiveType) node);
    } else if (node instanceof QualifiedName) {
      after((QualifiedName) node);
    } else if (node instanceof Resource) {
      after((Resource) node);
    } else if (node instanceof ReturnStatement) {
      after((ReturnStatement) node);
    } else if (node instanceof ScopedExpression) {
      after((ScopedExpression) node);
    } else if (node instanceof SuperExpression) {
      after((SuperExpression) node);
    } else if (node instanceof SuperInvocation) {
      after((SuperInvocation) node);
    } else if (node instanceof SwitchBlock) {
      after((SwitchBlock) node);
    } else if (node instanceof SwitchStatement) {
      after((SwitchStatement) node);
    } else if (node instanceof SynchronizedStatement) {
      after((SynchronizedStatement) node);
    } else if (node instanceof TernaryExpression) {
      after((TernaryExpression) node);
    } else if (node instanceof ThisExpression) {
      after((ThisExpression) node);
    } else if (node instanceof ThisInvocation) {
      after((ThisInvocation) node);
    } else if (node instanceof ThrowStatement) {
      after((ThrowStatement) node);
    } else if (node instanceof TryStatement) {
      after((TryStatement) node);
    } else if (node instanceof TypeCast) {
      after((TypeCast) node);
    } else if (node instanceof TypeParameter) {
      after((TypeParameter) node);
    } else if (node instanceof TypeWithArguments) {
      after((TypeWithArguments) node);
    } else if (node instanceof VariableDeclaration) {
      after((VariableDeclaration) node);
    } else if (node instanceof VoidType) {
      after((VoidType) node);
    } else if (node instanceof WhileStatement) {
      after((WhileStatement) node);
    } else if (node instanceof WildcardTypeArgument) {
      after((WildcardTypeArgument) node);
    }
  }

  @Override
  public void visitBefore(JavaNode node) {
    if (node instanceof Annotation) {
      before((Annotation) node);
    } else if (node instanceof AnnotationArrayInitializer) {
      before((AnnotationArrayInitializer) node);
    } else if (node instanceof AnnotationDeclaration) {
      before((AnnotationDeclaration) node);
    } else if (node instanceof AnnotationMethodDeclaration) {
      before((AnnotationMethodDeclaration) node);
    } else if (node instanceof ArrayAccess) {
      before((ArrayAccess) node);
    } else if (node instanceof ArrayCreation) {
      before((ArrayCreation) node);
    } else if (node instanceof ArrayCreationDimension) {
      before((ArrayCreationDimension) node);
    } else if (node instanceof ArrayInitializer) {
      before((ArrayInitializer) node);
    } else if (node instanceof AssertStatement) {
      before((AssertStatement) node);
    } else if (node instanceof Block) {
      before((Block) node);
    } else if (node instanceof BlockDeclaration) {
      before((BlockDeclaration) node);
    } else if (node instanceof BreakStatement) {
      before((BreakStatement) node);
    } else if (node instanceof CatchClause) {
      before((CatchClause) node);
    } else if (node instanceof ClassDeclaration) {
      before((ClassDeclaration) node);
    } else if (node instanceof ClassExpression) {
      before((ClassExpression) node);
    } else if (node instanceof ClassInstantiation) {
      before((ClassInstantiation) node);
    } else if (node instanceof ClassMethodDeclaration) {
      before((ClassMethodDeclaration) node);
    } else if (node instanceof ClassOrInterfaceType) {
      before((ClassOrInterfaceType) node);
    } else if (node instanceof CompilationUnit) {
      before((CompilationUnit) node);
    } else if (node instanceof ConstDeclaration) {
      before((ConstDeclaration) node);
    } else if (node instanceof ConstructorDeclaration) {
      before((ConstructorDeclaration) node);
    } else if (node instanceof ContinueStatement) {
      before((ContinueStatement) node);
    } else if (node instanceof DefaultSwitchLabel) {
      before((DefaultSwitchLabel) node);
    } else if (node instanceof DoWhileStatement) {
      before((DoWhileStatement) node);
    } else if (node instanceof EnumConstant) {
      before((EnumConstant) node);
    } else if (node instanceof EnumDeclaration) {
      before((EnumDeclaration) node);
    } else if (node instanceof ExpressionStatement) {
      before((ExpressionStatement) node);
    } else if (node instanceof FieldDeclaration) {
      before((FieldDeclaration) node);
    } else if (node instanceof ForEachControl) {
      before((ForEachControl) node);
    } else if (node instanceof ForStatement) {
      before((ForStatement) node);
    } else if (node instanceof FormalParameter) {
      before((FormalParameter) node);
    } else if (node instanceof GeneralInvocation) {
      before((GeneralInvocation) node);
    } else if (node instanceof Identifier) {
      before((Identifier) node);
    } else if (node instanceof IdentifierWithTypeArguments) {
      before((IdentifierWithTypeArguments) node);
    } else if (node instanceof IfStatement) {
      before((IfStatement) node);
    } else if (node instanceof ImportDeclaration) {
      before((ImportDeclaration) node);
    } else if (node instanceof InfixExpression) {
      before((InfixExpression) node);
    } else if (node instanceof InstanceOf) {
      before((InstanceOf) node);
    } else if (node instanceof InterfaceDeclaration) {
      before((InterfaceDeclaration) node);
    } else if (node instanceof InterfaceMethodDeclaration) {
      before((InterfaceMethodDeclaration) node);
    } else if (node instanceof Literal) {
      before((Literal) node);
    } else if (node instanceof LocalVariableDeclaration) {
      before((LocalVariableDeclaration) node);
    } else if (node instanceof LoopControl) {
      before((LoopControl) node);
    } else if (node instanceof MethodInvocation) {
      before((MethodInvocation) node);
    } else if (node instanceof NameValuePair) {
      before((NameValuePair) node);
    } else if (node instanceof PackageDeclaration) {
      before((PackageDeclaration) node);
    } else if (node instanceof PostfixExpression) {
      before((PostfixExpression) node);
    } else if (node instanceof PrefixExpression) {
      before((PrefixExpression) node);
    } else if (node instanceof PrimitiveType) {
      before((PrimitiveType) node);
    } else if (node instanceof QualifiedName) {
      before((QualifiedName) node);
    } else if (node instanceof Resource) {
      before((Resource) node);
    } else if (node instanceof ReturnStatement) {
      before((ReturnStatement) node);
    } else if (node instanceof ScopedExpression) {
      before((ScopedExpression) node);
    } else if (node instanceof SuperExpression) {
      before((SuperExpression) node);
    } else if (node instanceof SuperInvocation) {
      before((SuperInvocation) node);
    } else if (node instanceof SwitchBlock) {
      before((SwitchBlock) node);
    } else if (node instanceof SwitchStatement) {
      before((SwitchStatement) node);
    } else if (node instanceof SynchronizedStatement) {
      before((SynchronizedStatement) node);
    } else if (node instanceof TernaryExpression) {
      before((TernaryExpression) node);
    } else if (node instanceof ThisExpression) {
      before((ThisExpression) node);
    } else if (node instanceof ThisInvocation) {
      before((ThisInvocation) node);
    } else if (node instanceof ThrowStatement) {
      before((ThrowStatement) node);
    } else if (node instanceof TryStatement) {
      before((TryStatement) node);
    } else if (node instanceof TypeCast) {
      before((TypeCast) node);
    } else if (node instanceof TypeParameter) {
      before((TypeParameter) node);
    } else if (node instanceof TypeWithArguments) {
      before((TypeWithArguments) node);
    } else if (node instanceof VariableDeclaration) {
      before((VariableDeclaration) node);
    } else if (node instanceof VoidType) {
      before((VoidType) node);
    } else if (node instanceof WhileStatement) {
      before((WhileStatement) node);
    } else if (node instanceof WildcardTypeArgument) {
      before((WildcardTypeArgument) node);
    }
  }
}
