/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConverter;
import com.googlecode.mjorm.convert.converters.ArrayToMongoTypeConverter;
import com.googlecode.mjorm.convert.converters.BooleanTypeConverter;
import com.googlecode.mjorm.convert.converters.CharacterTypeConverter;
import com.googlecode.mjorm.convert.converters.CollectionToMongoTypeConverter;
import com.googlecode.mjorm.convert.converters.EnumToMongoTypeConverter;
import com.googlecode.mjorm.convert.converters.MapToMongoTypeConverter;
import com.googlecode.mjorm.convert.converters.MongoToArrayTypeConverter;
import com.googlecode.mjorm.convert.converters.MongoToCollectionTypeConverter;
import com.googlecode.mjorm.convert.converters.MongoToEnumTypeConverter;
import com.googlecode.mjorm.convert.converters.MongoToMapTypeConverter;
import com.googlecode.mjorm.convert.converters.NumberTypeConverter;
import com.googlecode.mjorm.convert.converters.ObjectIdToStringTypeConverter;
import com.googlecode.mjorm.convert.converters.StringToObjectIdTypeConverter;
import com.googlecode.mjorm.convert.converters.StringToUUIDConverter;
import com.googlecode.mjorm.convert.converters.StringTypeConverter;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectMapper
implements ObjectMapper {
    private ConversionContext conversionContext = new ConversionContext();

    public AbstractObjectMapper() {
        this.registerTypeConverter(new StringTypeConverter());
        this.registerTypeConverter(new NumberTypeConverter());
        this.registerTypeConverter(new CharacterTypeConverter());
        this.registerTypeConverter(new BooleanTypeConverter());
        this.registerTypeConverter(new ObjectIdToStringTypeConverter());
        this.registerTypeConverter(new StringToObjectIdTypeConverter());
        this.registerTypeConverter(new StringToUUIDConverter());
        this.registerTypeConverter(new ArrayToMongoTypeConverter());
        this.registerTypeConverter(new CollectionToMongoTypeConverter());
        this.registerTypeConverter(new EnumToMongoTypeConverter());
        this.registerTypeConverter(new MapToMongoTypeConverter());
        this.registerTypeConverter(new MongoToArrayTypeConverter());
        this.registerTypeConverter(new MongoToCollectionTypeConverter());
        this.registerTypeConverter(new MongoToMapTypeConverter());
        this.registerTypeConverter(new MongoToEnumTypeConverter());
    }

    @Override
    public <T> T map(DBObject dbObject, Class<T> objectClass) {
        try {
            return this.conversionContext.convert(dbObject, JavaType.fromType(objectClass));
        }
        catch (ConversionException ce) {
            throw new MjormException(ce);
        }
    }

    @Override
    public <T> DBObject unmap(T object) {
        try {
            return (DBObject)this.conversionContext.convert(object, JavaType.fromType(BasicDBObject.class));
        }
        catch (ConversionException ce) {
            throw new MjormException(ce);
        }
    }

    @Override
    public <T> Object unmapValue(T object) throws MjormException {
        try {
            if (object == null) {
                return null;
            }
            JavaType storageType = this.conversionContext.getStorageType(object.getClass());
            return this.conversionContext.convert(object, storageType);
        }
        catch (ConversionException ce) {
            throw new MjormException(ce);
        }
    }

    public void registerTypeConverter(TypeConverter<?, ?> typeConverter) {
        this.conversionContext.registerTypeConverter(typeConverter);
    }
}

