/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;

public class DBObjectUtil {
    public static final MergeConflictResolver THROW_EXCEPTION = new MergeConflictResolver(){

        public void resolve(DBObject from, DBObject into, String field) {
            Object toVal;
            Object fromVal = from.get(field);
            if (!fromVal.equals(toVal = into.get(field))) {
                throw new IllegalStateException("Unable to merge " + field);
            }
        }
    };

    public static boolean isList(Object dbObject) {
        return BasicDBList.class.isInstance(dbObject);
    }

    public static boolean isDBObject(Object dbObject) {
        return DBObject.class.isInstance(dbObject);
    }

    public static void merge(DBObject from, DBObject into) {
        DBObjectUtil.merge(from, into, THROW_EXCEPTION);
    }

    public static void merge(DBObject from, DBObject into, MergeConflictResolver resolver) {
        for (String field : from.keySet()) {
            Object intoVal;
            if (!into.containsField(field)) {
                into.put(field, from.get(field));
                continue;
            }
            Object fromVal = from.get(field);
            if (fromVal.equals(intoVal = into.get(field))) continue;
            if (!DBObjectUtil.isDBObject(intoVal) || !DBObjectUtil.isDBObject(fromVal)) {
                resolver.resolve(from, into, field);
                continue;
            }
            if (DBObjectUtil.isList(intoVal) || DBObjectUtil.isList(fromVal)) {
                resolver.resolve(from, into, field);
                continue;
            }
            DBObjectUtil.merge((DBObject)DBObject.class.cast(fromVal), (DBObject)DBObject.class.cast(intoVal), resolver);
        }
    }

    public static Object getNestedProperty(DBObject dbObject, String name) {
        String[] names = name.split("\\.");
        Object ret = null;
        boolean hasMore = false;
        for (int i = 0; i < names.length; ++i) {
            hasMore = i < names.length - 1;
            ret = dbObject.get(names[i]);
            if (hasMore && DBObject.class.isInstance(ret)) {
                dbObject = (DBObject)DBObject.class.cast(ret);
                continue;
            }
            if (!hasMore) continue;
            throw new IllegalArgumentException("Property " + name + " could not be followed");
        }
        return ret;
    }

    public static interface MergeConflictResolver {
        public void resolve(DBObject var1, DBObject var2, String var3);
    }
}

