/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;

public class MapReduceResult {
    private DBCollection resultCollection;
    private Long numObjectsScanned;
    private Long numEmits;
    private Long numObjectsOutput;
    private Long timeMillis;

    public MapReduceResult(MapReduceOutput output) {
        this.resultCollection = output.getOutputCollection();
        CommandResult result = output.getCommandResult();
        if (result.containsField("counts")) {
            DBObject counts = (DBObject)result.get("counts");
            this.numObjectsScanned = new Long(counts.get("input").toString());
            this.numEmits = new Long(counts.get("emit").toString());
            this.numObjectsOutput = new Long(counts.get("output").toString());
        }
        if (result.containsField("timeMillis")) {
            this.timeMillis = new Long(result.get("timeMillis").toString());
        }
    }

    public DBCollection getResultCollection() {
        return this.resultCollection;
    }

    public Long getNumObjectsScanned() {
        return this.numObjectsScanned;
    }

    public Long getNumEmits() {
        return this.numEmits;
    }

    public Long getNumObjectsOutput() {
        return this.numObjectsOutput;
    }

    public Long getTimeMillis() {
        return this.timeMillis;
    }
}

