/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.DiscriminatorType;
import com.googlecode.mjorm.MjormException;

public class MappingUtil {
    public static Object parseDiscriminator(String value, DiscriminatorType type) {
        try {
            switch (type) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
                case CHARACTER: {
                    return new Character(value.charAt(0));
                }
                case DOUBLE: {
                    return new Double(value);
                }
                case FLOAT: {
                    return new Float(value);
                }
                case LONG: {
                    return new Long(value);
                }
                case INTEGER: {
                    return new Integer(value);
                }
                case SHORT: {
                    return new Short(value);
                }
                case STRING: {
                    return value;
                }
            }
        }
        catch (Exception e) {
            throw new MjormException("Error parsing discrininator", e);
        }
        throw new MjormException("Error determining discriminator type for " + (Object)((Object)type));
    }

    public static Object parseDiscriminator(String value, String type) {
        return MappingUtil.parseDiscriminator(value, DiscriminatorType.valueOf(type.toUpperCase()));
    }
}

