/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MapReduce;
import com.googlecode.mjorm.MapReduceResult;
import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.MongoDao;
import com.googlecode.mjorm.ObjectIterator;
import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.MqlException;
import com.googlecode.mjorm.mql.Statement;
import com.googlecode.mjorm.mql.StatementImpl;
import com.googlecode.mjorm.query.DaoQuery;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.WriteConcern;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDaoImpl
implements MongoDao {
    private DB db;
    private ObjectMapper objectMapper;

    public MongoDaoImpl(DB db, ObjectMapper objectMapper) {
        this.db = db;
        this.objectMapper = objectMapper;
    }

    public MongoDaoImpl() {
        this(null, null);
    }

    @Override
    public Statement createStatement(String mql) {
        try {
            return new StatementImpl(new ByteArrayInputStream(mql.getBytes()), this.db, this.objectMapper);
        }
        catch (Exception e) {
            throw new MqlException(e);
        }
    }

    @Override
    public DaoQuery createQuery() {
        return new DaoQuery().setDB(this.db).setObjectMapper(this.objectMapper);
    }

    @Override
    public long countObjects(String collection, DBObject query) {
        return this.getCollection(collection).count(query);
    }

    @Override
    public <T> T createObject(String collection, T object, WriteConcern concern) {
        try {
            DBObject dbObject = this.objectMapper.unmap(object);
            this.getCollection(collection).insert(dbObject, concern);
            return (T)this.objectMapper.map(dbObject, object.getClass());
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    @Override
    public <T> T createObject(String collection, T object) {
        return this.createObject(collection, object, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public <T> T[] createObjects(String collection, T[] objects) {
        return this.createObjects(collection, objects, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public <T> T[] createObjects(String collection, T[] objects, WriteConcern concern) {
        DBObject[] dbObjects = new DBObject[objects.length];
        try {
            for (int i = 0; i < objects.length; ++i) {
                dbObjects[i] = this.objectMapper.unmap(objects[i]);
            }
            this.getCollection(collection).insert(dbObjects, concern);
            Object[] ret = (Object[])Array.newInstance(objects[0].getClass(), objects.length);
            for (int i = 0; i < objects.length; ++i) {
                ret[i] = this.objectMapper.map(dbObjects[i], objects[i].getClass());
            }
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
        return null;
    }

    @Override
    public void deleteObject(String collection, Object id, WriteConcern concern) {
        this.deleteObjects(collection, (DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), concern);
    }

    @Override
    public void deleteObject(String collection, Object id) {
        this.deleteObject(collection, id, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public void deleteObjects(String collection, Object[] ids, WriteConcern concern) {
        this.deleteObjects(collection, (DBObject)new BasicDBObject("_id", (Object)new BasicDBObject("$in", this.objectMapper.unmapValue(ids))), concern);
    }

    @Override
    public void deleteObjects(String collection, Object[] ids) {
        this.deleteObjects(collection, ids, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public void deleteObjects(String collection, DBObject query, WriteConcern concern) {
        this.getCollection(collection).remove(query, concern);
    }

    @Override
    public void deleteObjects(String collection, DBObject query) {
        this.deleteObjects(collection, query, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public <T> T getPartialObject(String collection, Object id, String name, Class<T> clazz) {
        return this.getPartialObject(collection, (DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), name, clazz);
    }

    @Override
    public <T> T getPartialObject(String collection, DBObject query, String name, Class<T> clazz) {
        DBObject dbObject = this.getCollection(collection).findOne(query, (DBObject)new BasicDBObject(name, (Object)1));
        if (dbObject == null) {
            return null;
        }
        Object value = null;
        for (String part : name.split("\\.")) {
            if (!dbObject.containsField(part)) {
                return null;
            }
            value = dbObject.get(part);
            if (!DBObject.class.isInstance(value)) break;
            dbObject = (DBObject)DBObject.class.cast(value);
        }
        return (T)(!this.isPrimitive(clazz) ? (Object)this.objectMapper.map(dbObject, clazz) : value);
    }

    @Override
    public <T> void savePartialObject(String collection, Object id, String name, T data, boolean upsert, WriteConcern concern) {
        this.savePartialObject(collection, (DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), name, data, upsert);
    }

    @Override
    public <T> void savePartialObject(String collection, Object id, String name, T data, boolean upsert) {
        this.savePartialObject(collection, (DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), name, data, upsert, this.getCollection(collection).getWriteConcern());
    }

    public <T> void savePartialObject(String collection, DBObject query, String name, T data, boolean upsert) {
        this.savePartialObject(collection, query, name, data, upsert, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public <T> void savePartialObject(String collection, DBObject query, String name, T data, boolean upsert, WriteConcern concern) {
        Object value = null;
        if (data != null) {
            Class<?> clazz = data.getClass();
            value = (!this.isPrimitive(clazz) ? this.objectMapper.unmap(data) : data);
        }
        this.getCollection(collection).update(query, (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject(name, value)), upsert, false, concern);
    }

    @Override
    public void deletePartialObject(String collection, DBObject query, String name, WriteConcern concern) {
        this.getCollection(collection).update(query, (DBObject)new BasicDBObject("$unset", (Object)new BasicDBObject(name, (Object)1)), false, false);
    }

    @Override
    public void deletePartialObject(String collection, DBObject query, String name) {
        this.deletePartialObject(collection, query, name, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public void deletePartialObject(String collection, Object id, String name, WriteConcern concern) {
        this.deletePartialObject(collection, (DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), name, concern);
    }

    @Override
    public void deletePartialObject(String collection, Object id, String name) {
        this.deletePartialObject(collection, id, name, this.getCollection(collection).getWriteConcern());
    }

    @Override
    public <T> ObjectIterator<T> findByExample(String collection, T example, Class<T> clazz) {
        DBObject query;
        try {
            query = this.objectMapper.unmap(example);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
        return this.findObjects(collection, query, clazz);
    }

    @Override
    public <T> T findObject(String collection, DBObject query, Class<T> clazz) {
        DBObject dbObject = this.getCollection(collection).findOne(query);
        try {
            return this.objectMapper.map(dbObject, clazz);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    @Override
    public <T> ObjectIterator<T> findObjects(String collection, DBObject query, Class<T> clazz) {
        DBCursor cursor = this.getCollection(collection).find(query);
        return new ObjectIterator<T>(cursor, this.objectMapper, clazz);
    }

    @Override
    public DBCollection getCollection(String name) {
        return this.db.getCollection(name);
    }

    @Override
    public DB getDB() {
        return this.db;
    }

    @Override
    public <T> T readObject(String collection, Object id, Class<T> clazz) {
        DBObject dbObject = this.getCollection(collection).findOne((DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)));
        try {
            return this.objectMapper.map(dbObject, clazz);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    @Override
    public <T> T[] readObjects(String collection, Object[] ids, Class<T> clazz) {
        DBCursor cursor = this.getCollection(collection).find((DBObject)new BasicDBObject("_id", (Object)new BasicDBObject("$in", this.objectMapper.unmapValue(ids))));
        try {
            ArrayList<T> ret = new ArrayList<T>();
            while (cursor.hasNext()) {
                ret.add(this.objectMapper.map(cursor.next(), clazz));
            }
            return ret.toArray((Object[])Array.newInstance(clazz, 0));
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    @Override
    public void updateObject(String collection, Object id, Object o, WriteConcern concern) {
        DBObject dbObject;
        try {
            dbObject = this.objectMapper.unmap(o);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
        this.getCollection(collection).update((DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), dbObject, false, false, concern);
    }

    @Override
    public void updateObject(String collection, Object id, Object o) {
        DBObject dbObject;
        try {
            dbObject = this.objectMapper.unmap(o);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
        this.getCollection(collection).update((DBObject)new BasicDBObject("_id", this.objectMapper.unmapValue(id)), dbObject);
    }

    @Override
    public CommandResult executeCommand(DBObject cmd) {
        CommandResult result = this.getDB().command(cmd);
        result.throwOnError();
        return result;
    }

    @Override
    public CommandResult executeCommand(String cmd) {
        CommandResult result = this.getDB().command(cmd);
        result.throwOnError();
        return result;
    }

    @Override
    public void ensureIndex(String collection, String key, boolean background, boolean unique, boolean dropDupes) {
        this.ensureIndex(collection, (DBObject)new BasicDBObject(key, (Object)1), background, unique, dropDupes);
    }

    @Override
    public void ensureIndex(String collection, DBObject keys, boolean background, boolean unique, boolean dropDupes) {
        this.getCollection(collection).ensureIndex(keys, BasicDBObjectBuilder.start().add("unique", (Object)unique).add("dropDups", (Object)dropDupes).add("background", (Object)background).get());
    }

    @Override
    public MapReduceResult mapReduce(String collection, MapReduce mapReduce) {
        if (mapReduce.getOutputCollectionName() == null || mapReduce.getOutputCollectionName().trim().length() == 0) {
            throw new IllegalArgumentException("Invalid output collection name");
        }
        MapReduceCommand cmd = new MapReduceCommand(this.getCollection(collection), mapReduce.getMapFunction(), mapReduce.getReduceFunction(), mapReduce.getOutputCollectionName(), mapReduce.getOutputType(), mapReduce.getQuery());
        if (mapReduce.getSort() != null) {
            cmd.setSort(mapReduce.getSort());
        }
        if (mapReduce.getLimit() != null) {
            cmd.setLimit(mapReduce.getLimit().intValue());
        }
        if (mapReduce.getFinalizeFunction() != null) {
            cmd.setFinalize(mapReduce.getFinalizeFunction());
        }
        if (mapReduce.getScope() != null) {
            cmd.setScope(mapReduce.getScope());
        }
        if (mapReduce.getVerbose() != null) {
            cmd.setVerbose(mapReduce.getVerbose());
        }
        if (mapReduce.getOutputDBName() != null) {
            cmd.setOutputDB(mapReduce.getOutputDBName());
        }
        return new MapReduceResult(this.getCollection(collection).mapReduce(cmd));
    }

    @Override
    public <T> T findAndDelete(String collection, DBObject query, DBObject sort, Class<T> clazz, String[] fields) {
        BasicDBObject fieldsObject = null;
        if (fields != null && fields.length > 0) {
            fieldsObject = new BasicDBObject();
            for (String field : fields) {
                fieldsObject.put(field, (Object)1);
            }
        }
        return this.objectMapper.map(this.getCollection(collection).findAndModify(query, (DBObject)fieldsObject, sort, true, null, false, false), clazz);
    }

    @Override
    public <T> T findAndDelete(String collection, DBObject query, DBObject sort, Class<T> clazz) {
        return this.findAndDelete(collection, query, sort, clazz, null);
    }

    @Override
    public <T> T findAndModify(String collection, DBObject query, DBObject sort, DBObject update, boolean returnNew, boolean upsert, Class<T> clazz, String[] fields) {
        BasicDBObject fieldsObject = null;
        if (fields != null && fields.length > 0) {
            fieldsObject = new BasicDBObject();
            for (String field : fields) {
                fieldsObject.put(field, (Object)1);
            }
        }
        return this.objectMapper.map(this.getCollection(collection).findAndModify(query, (DBObject)fieldsObject, sort, false, update, returnNew, upsert), clazz);
    }

    @Override
    public <T> T findAndModify(String collection, DBObject query, DBObject sort, DBObject update, boolean returnNew, boolean upsert, Class<T> clazz) {
        return this.findAndModify(collection, query, sort, update, returnNew, upsert, clazz, null);
    }

    @Override
    public void update(String collection, DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) {
        this.getCollection(collection).update(query, update, upsert, multi, concern, encoder);
    }

    @Override
    public void update(String collection, DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern concern) {
        this.update(collection, query, update, upsert, multi, concern, null);
    }

    @Override
    public void update(String collection, DBObject query, DBObject update, boolean upsert, boolean multi) {
        this.update(collection, query, update, upsert, multi, null, null);
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(String.class) || clazz.equals(Byte.class);
    }

    public void setDb(DB db) {
        this.db = db;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

