/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDescriptor {
    private Class<?> type;
    private Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
    private String discriminatorName;
    private String discriminatorType;
    private Map<Object, ObjectDescriptor> subClassObjectDescriptors = new HashMap<Object, ObjectDescriptor>();

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> objectClass) {
        this.type = objectClass;
    }

    public String getDiscriminatorName() {
        return this.discriminatorName;
    }

    public void setDiscriminatorName(String discriminatorName) {
        this.discriminatorName = discriminatorName;
    }

    public String getDiscriminatorType() {
        return this.discriminatorType;
    }

    public void setDiscriminatorType(String discriminatorType) {
        this.discriminatorType = discriminatorType;
    }

    public boolean hasSubClasses() {
        return !this.subClassObjectDescriptors.isEmpty();
    }

    public void addSubClassObjectDescriptor(Object discriminator, ObjectDescriptor descriptor) {
        if (this.type == null) {
            throw new MjormException("ObjectDescriptors without a type cann't have subclass ObjectDescriptors");
        }
        if (this.subClassObjectDescriptors.containsKey(discriminator)) {
            throw new MjormException("ObjectDescriptor for discriminator " + discriminator + " already exists");
        }
        if (!this.type.isAssignableFrom(descriptor.getType())) {
            throw new MjormException("ObjectDescriptor for discriminator " + discriminator + " does not inherit from " + descriptor.getType());
        }
        this.subClassObjectDescriptors.put(discriminator, descriptor);
    }

    public ObjectDescriptor getSubClassObjectDescriptor(Object discriminator) {
        return this.subClassObjectDescriptors.get(discriminator);
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.properties.get(propertyName.toLowerCase());
    }

    public PropertyDescriptor[] getProperties() {
        return this.properties.values().toArray(new PropertyDescriptor[0]);
    }

    public void addPropertyDescriptor(PropertyDescriptor desc) {
        if (this.properties.containsKey(desc.getName().toLowerCase())) {
            throw new IllegalArgumentException("PropertyDescriptor for " + desc.getName() + " exists");
        }
        this.properties.put(desc.getName().toLowerCase(), desc);
    }
}

