/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.ObjectDescriptor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDescriptorRegistry {
    private Map<Class<?>, ObjectDescriptor> descriptors = new HashMap();

    public void registerDescriptor(ObjectDescriptor descriptor) {
        if (this.descriptors.containsKey(descriptor.getType())) {
            throw new IllegalStateException("ObjectDescriptor for " + descriptor.getType().getName() + " exists");
        }
        this.descriptors.put(descriptor.getType(), descriptor);
    }

    public boolean hasDescriptor(Class<?> clazz) {
        return this.descriptors.containsKey(clazz);
    }

    public boolean hasDescriptor(Type type) {
        if (Class.class.isInstance(type)) {
            return this.hasDescriptor((Class)Class.class.cast(type));
        }
        return false;
    }

    public ObjectDescriptor getDescriptor(Class<?> clazz) {
        return this.descriptors.get(clazz);
    }

    public ObjectDescriptor getDescriptor(Type type) {
        if (Class.class.isInstance(type)) {
            return this.getDescriptor((Class)Class.class.cast(type));
        }
        return null;
    }

    public LinkedList<ObjectDescriptor> getDescriptorsForType(Type type) {
        LinkedList<Type> hierarchy = this.getClassHierarchy(type);
        LinkedList<ObjectDescriptor> ret = new LinkedList<ObjectDescriptor>();
        for (Type clazz : hierarchy) {
            ObjectDescriptor desc = this.getDescriptor(clazz);
            if (desc == null) continue;
            ret.add(desc);
        }
        return ret;
    }

    private LinkedList<Type> getClassHierarchy(Type type) {
        LinkedList<Type> ret = new LinkedList<Type>();
        while (type != null && !Object.class.equals((Object)type)) {
            ret.add(type);
            if (!Class.class.isInstance(type)) continue;
            type = ((Class)Class.class.cast(type)).getSuperclass();
        }
        Collections.reverse(ret);
        return ret;
    }
}

