/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectMapper;
import com.mongodb.DBCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIterator<E>
implements Iterable<E>,
Iterator<E> {
    private DBCursor cursor;
    private final ObjectMapper objectMapper;
    private final Class<E> clazz;

    public ObjectIterator(DBCursor cursor, ObjectMapper objectMapper, Class<E> clazz) {
        this.cursor = cursor;
        this.objectMapper = objectMapper;
        this.clazz = clazz;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public List<E> readAll(List<E> ret) {
        while (this.hasNext()) {
            ret.add(this.next());
        }
        return ret;
    }

    public List<E> readAll() {
        return this.readAll(new ArrayList());
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public E next() {
        try {
            return this.objectMapper.map(this.cursor.next(), this.clazz);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    public E current() {
        try {
            return this.objectMapper.map(this.cursor.curr(), this.clazz);
        }
        catch (Exception e) {
            throw new MjormException(e);
        }
    }

    @Override
    public void remove() {
        this.cursor.remove();
    }

    public DBCursor getDBCursor() {
        return this.cursor;
    }
}

