/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T instantiate(Class<T> clazz, Object ... args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args.length == 0) {
            return clazz.newInstance();
        }
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args.getClass();
        }
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            boolean foundCtr = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isAssignableFrom(types[i])) continue;
                foundCtr = false;
                break;
            }
            if (!foundCtr) continue;
            return (T)c.newInstance(args);
        }
        throw new IllegalArgumentException("Unable to find suitable constructor for " + clazz.getName());
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static PropertyDescriptor findPropertyDescriptor(Class<?> clazz, String name) {
        BeanInfo info = ReflectionUtil.getBeanInfo(clazz);
        for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
            if (!desc.getName().equalsIgnoreCase(name)) continue;
            return desc;
        }
        return null;
    }

    public static Method findGetter(Class<?> clazz, String name) {
        PropertyDescriptor pd = ReflectionUtil.findPropertyDescriptor(clazz, name);
        return pd != null ? pd.getReadMethod() : null;
    }

    public static Method findSetter(Class<?> clazz, String name) {
        PropertyDescriptor pd = ReflectionUtil.findPropertyDescriptor(clazz, name);
        return pd != null ? pd.getWriteMethod() : null;
    }

    static {
        new ReflectionUtil();
    }
}

