/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MappingUtil;
import com.googlecode.mjorm.ObjectDescriptor;
import com.googlecode.mjorm.ObjectIdValueGenerator;
import com.googlecode.mjorm.PropertyDescriptor;
import com.googlecode.mjorm.ReflectionUtil;
import com.googlecode.mjorm.ValueGenerator;
import com.googlecode.mjorm.convert.JavaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bson.types.ObjectId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectDescriptorParser {
    private XPath xpath;
    private DocumentBuilder builder;

    public List<ObjectDescriptor> parseDocument(File file) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, ClassNotFoundException {
        return this.parseDocument(new FileInputStream(file));
    }

    public List<ObjectDescriptor> parseDocument(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, ClassNotFoundException {
        if (this.builder == null) {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        return this.parseDocument(this.builder.parse(inputStream));
    }

    public List<ObjectDescriptor> parseDocument(Document doc) throws XPathExpressionException, ClassNotFoundException {
        if (this.xpath == null) {
            this.xpath = XPathFactory.newInstance().newXPath();
        }
        ArrayList<ObjectDescriptor> ret = new ArrayList<ObjectDescriptor>();
        NodeList descriptorEls = (NodeList)this.xpath.evaluate("/descriptors/object", doc, XPathConstants.NODESET);
        for (int i = 0; i < descriptorEls.getLength(); ++i) {
            ObjectDescriptor descriptor = this.parseDescriptor((Element)Element.class.cast(descriptorEls.item(i)), ret);
            ret.add(descriptor);
        }
        return ret;
    }

    private ObjectDescriptor parseDescriptor(Element descriptorEl, List<ObjectDescriptor> descriptors) throws XPathExpressionException, ClassNotFoundException {
        ObjectDescriptor descriptor = new ObjectDescriptor();
        Class<?> objClass = Class.forName(descriptorEl.getAttribute("class"));
        String discriminatorName = descriptorEl.hasAttribute("discriminator-name") ? descriptorEl.getAttribute("discriminator-name") : null;
        String discriminatorType = descriptorEl.hasAttribute("discriminator-type") ? descriptorEl.getAttribute("discriminator-type") : null;
        descriptor.setType(objClass);
        descriptor.setDiscriminatorName(discriminatorName);
        descriptor.setDiscriminatorType(discriminatorType);
        NodeList propertyEls = (NodeList)this.xpath.evaluate("./property", descriptorEl, XPathConstants.NODESET);
        boolean foundIdentifier = false;
        for (int i = 0; i < propertyEls.getLength(); ++i) {
            String propField;
            Element propertyEl = (Element)propertyEls.item(i);
            String propName = propertyEl.getAttribute("name");
            Type propType = propertyEl.hasAttribute("class") ? Class.forName(propertyEl.getAttribute("class")) : null;
            Class<Object> storageType = propertyEl.hasAttribute("storageClass") ? Class.forName(propertyEl.getAttribute("storageClass")) : null;
            boolean propIsIdentifier = propertyEl.hasAttribute("id") && Boolean.parseBoolean(propertyEl.getAttribute("id"));
            boolean propIsAutoGen = false;
            ValueGenerator<ObjectId> valueGenerator = null;
            if (propertyEl.hasAttribute("auto")) {
                propIsAutoGen = true;
                String value = propertyEl.getAttribute("auto");
                if (value.toLowerCase().trim().equals("true")) {
                    valueGenerator = ObjectIdValueGenerator.INSTANCE;
                    storageType = ObjectId.class;
                } else {
                    try {
                        valueGenerator = (ValueGenerator)ValueGenerator.class.cast(Class.forName(value).newInstance());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to create ValueGenerator for " + value, e);
                    }
                }
            }
            String string = propField = propertyEl.hasAttribute("field") ? propertyEl.getAttribute("field") : null;
            if (propField == null && propertyEl.hasAttribute("column")) {
                propField = propertyEl.getAttribute("column");
            }
            if (propField == null) {
                propField = propIsIdentifier ? "_id" : propName;
            }
            Method propSetter = ReflectionUtil.findSetter(objClass, propName);
            Method propGetter = ReflectionUtil.findGetter(objClass, propName);
            if (propGetter == null || propSetter == null) {
                throw new IllegalArgumentException("Unable to find getter or setter named " + propName + " for: " + objClass);
            }
            if (propIsIdentifier && !foundIdentifier) {
                foundIdentifier = true;
            } else if (propIsIdentifier && foundIdentifier) {
                throw new IllegalArgumentException("Two identifiers found for: " + objClass);
            }
            NodeList parameterTypeEls = (NodeList)this.xpath.evaluate("./type-param", propertyEl, XPathConstants.NODESET);
            Type[] genericParameterTypes = new Class[parameterTypeEls.getLength()];
            for (int k = 0; k < parameterTypeEls.getLength(); ++k) {
                Element parameterTypeEl = (Element)parameterTypeEls.item(k);
                genericParameterTypes[k] = Class.forName(parameterTypeEl.getAttribute("class"));
            }
            NodeList conversionHints = (NodeList)this.xpath.evaluate("./conversion-hints/hint", propertyEl, XPathConstants.NODESET);
            if (conversionHints.getLength() == 0) {
                conversionHints = (NodeList)this.xpath.evaluate("./translation-hints/hint", propertyEl, XPathConstants.NODESET);
            }
            HashMap<String, Object> hints = new HashMap<String, Object>();
            for (int k = 0; k < conversionHints.getLength(); ++k) {
                Element hintEl = (Element)conversionHints.item(k);
                hints.put(hintEl.getAttribute("name"), hintEl.getTextContent());
            }
            if (propType == null) {
                propType = propGetter.getGenericReturnType();
            }
            PropertyDescriptor prop = new PropertyDescriptor();
            prop.setName(propName);
            prop.setFieldName(propField);
            prop.setGetter(propGetter);
            prop.setSetter(propSetter);
            prop.setIdentifier(propIsIdentifier);
            prop.setType(JavaType.fromType(propType));
            prop.setAutoGenerated(propIsAutoGen);
            prop.setValueGenerator(valueGenerator);
            prop.setConversionHints(hints);
            prop.setGenericParameterTypes(genericParameterTypes);
            if (storageType != null) {
                prop.setStorageType(JavaType.fromType(storageType));
            }
            descriptor.addPropertyDescriptor(prop);
        }
        NodeList subClassEls = (NodeList)this.xpath.evaluate("./subclass", descriptorEl, XPathConstants.NODESET);
        for (int i = 0; i < subClassEls.getLength(); ++i) {
            Element subClassEl = (Element)subClassEls.item(i);
            Object discriminatorValue = MappingUtil.parseDiscriminator(subClassEl.getAttribute("discriminator-value"), discriminatorType);
            ObjectDescriptor subClass = this.parseDescriptor(subClassEl, descriptors);
            descriptor.addSubClassObjectDescriptor(discriminatorValue, subClass);
            descriptors.add(subClass);
        }
        return descriptor;
    }
}

