/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert;

import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionContext {
    private Collection<TypeConverter<?, ?>> typeConverters = new LinkedList();
    private Map<String, TypeConverter<?, ?>> typeConverterCache = new HashMap();
    private Map<Class<?>, Class<?>> storageClasses = new HashMap();

    public JavaType getStorageType(Class<?> clazz) throws ConversionException {
        Class<Object> ret = this.storageClasses.get(clazz);
        if (ret == null) {
            ret = clazz.isPrimitive() ? clazz : (String.class.isAssignableFrom(clazz) ? clazz : (Number.class.isAssignableFrom(clazz) ? clazz : (Boolean.class.isAssignableFrom(clazz) ? clazz : (Character.class.isAssignableFrom(clazz) ? clazz : (Date.class.isAssignableFrom(clazz) ? clazz : (ObjectId.class.equals(clazz) ? clazz : (UUID.class.equals(clazz) ? String.class : (clazz.isArray() ? BasicDBList.class : (Collection.class.isAssignableFrom(clazz) ? BasicDBList.class : (Map.class.isAssignableFrom(clazz) ? BasicDBObject.class : (Enum.class.isAssignableFrom(clazz) ? String.class : BasicDBObject.class)))))))))));
        }
        return JavaType.fromType(ret);
    }

    public <S, T> T convert(S source, JavaType targetType) throws ConversionException {
        return this.convert(source, targetType, TypeConversionHints.NO_HINTS);
    }

    public <S, T> T convert(S source, JavaType targetType, TypeConversionHints hints) throws ConversionException {
        if (hints == null) {
            throw new IllegalArgumentException("Must have TypeConversionHints, consider TypeConversionHints.NO_HINTS or the variation of convert() that doesn't have a TypeConversionHints parameter");
        }
        if (source == null) {
            return null;
        }
        if (targetType == null) {
            throw new IllegalArgumentException("Must have a targetType and it must be instantiable");
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass.equals(targetType.asClass())) {
            return (T)source;
        }
        TypeConverter<S, T> conv = this.getConverter(sourceClass, targetType.asClass());
        if (conv == null) {
            throw new ConversionException("Unable to map " + sourceClass + " to " + targetType);
        }
        return conv.convert(source, targetType, this, hints);
    }

    public <S, T> TypeConverter<S, T> getConverter(Class<?> sourceClass, Class<?> targetClass) {
        String cacheKey = sourceClass.getName() + "_" + targetClass.getName();
        if (this.typeConverterCache.containsKey(cacheKey)) {
            return this.typeConverterCache.get(cacheKey);
        }
        for (TypeConverter<?, ?> conv : this.typeConverters) {
            if (!conv.canConvert(sourceClass, targetClass)) continue;
            this.typeConverterCache.put(cacheKey, conv);
            return conv;
        }
        return null;
    }

    public void registerTypeConverter(TypeConverter<?, ?> typeConverter) {
        this.typeConverterCache.clear();
        this.typeConverters.add(typeConverter);
    }
}

