/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaType {
    private static final Map<Type, JavaType> CACHE = new HashMap<Type, JavaType>();
    private Type type;
    private ParameterizedType parameterizedType;
    private Class<?> clazz;
    private Class<?> componentType;
    private Type[] typeParameters;
    private boolean instantiable;
    private boolean genericInfo;

    public static JavaType[] fromTypes(Type ... types) {
        JavaType[] ret = new JavaType[types.length];
        for (int i = 0; i < types.length; ++i) {
            ret[i] = JavaType.fromType(types[i]);
        }
        return ret;
    }

    public static JavaType fromType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type can't be null");
        }
        if (!CACHE.containsKey(type)) {
            CACHE.put(type, new JavaType(type));
        }
        return CACHE.get(type);
    }

    private JavaType(Type type) {
        this.type = type;
        this.parameterizedType = ParameterizedType.class.isInstance(type) ? (ParameterizedType)ParameterizedType.class.cast(type) : null;
        boolean bl = this.genericInfo = this.parameterizedType != null;
        this.clazz = Class.class.isInstance(type) ? (Class)Class.class.cast(type) : (this.parameterizedType != null ? (Class)Class.class.cast(this.parameterizedType.getRawType()) : null);
        if (this.clazz != null && this.clazz.getComponentType() != null) {
            this.componentType = this.clazz.getComponentType();
        }
        this.instantiable = this.clazz != null;
        this.typeParameters = this.parameterizedType != null ? this.parameterizedType.getActualTypeArguments() : null;
        this.genericInfo = this.typeParameters != null;
    }

    public boolean is(Type type) {
        return type != null ? this.type.equals(type) : false;
    }

    public Type getType() {
        return this.type;
    }

    public ParameterizedType asParameterizedType() {
        return this.parameterizedType;
    }

    public Class<?> asClass() {
        return this.clazz;
    }

    public Type[] getTypeParameters() {
        return this.typeParameters;
    }

    public Type getTypeParameter(int index) {
        return this.typeParameters != null && this.typeParameters.length > index ? this.typeParameters[index] : null;
    }

    public JavaType getJavaTypeParameter(int index) {
        Type type = this.getTypeParameter(index);
        return type == null ? null : JavaType.fromType(type);
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public boolean hasGenericInfo() {
        return this.genericInfo;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public JavaType getComponentJavaType() {
        return this.componentType != null ? JavaType.fromType(this.componentType) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaType other = (JavaType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "JavaType(" + this.type.toString() + ")";
    }
}

