/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToMongoTypeConverter
implements TypeConverter<Object[], BasicDBList> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return !BasicDBList.class.isAssignableFrom(sourceClass) && BasicDBList.class.equals(targetClass) && sourceClass.isArray();
    }

    @Override
    public BasicDBList convert(Object[] source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        BasicDBList ret = new BasicDBList();
        for (int i = 0; i < source.length; ++i) {
            Object value = source[i];
            if (value != null) {
                JavaType storageType = context.getStorageType(value.getClass());
                value = context.convert(value, storageType);
            }
            ret.add(value);
        }
        return ret;
    }
}

