/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanTypeConverter
implements TypeConverter<Object, Boolean> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return (Number.class.isAssignableFrom(sourceClass) || Character.class.isAssignableFrom(sourceClass) || String.class.isAssignableFrom(sourceClass)) && Boolean.class.equals(targetClass);
    }

    @Override
    public Boolean convert(Object source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        if (Number.class.isInstance(source)) {
            return ((Number)Number.class.cast(source)).intValue() == 1;
        }
        if (Character.class.isInstance(source)) {
            char c = ((Character)Character.class.cast(source)).charValue();
            return c == '\u0001';
        }
        if (String.class.isInstance(source)) {
            return Boolean.valueOf((String)String.class.cast(source));
        }
        throw new ConversionException("Unable to convert source to boolean");
    }
}

