/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterTypeConverter
implements TypeConverter<Object, Character> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return (Number.class.isAssignableFrom(sourceClass) || String.class.isAssignableFrom(sourceClass) || Boolean.class.isAssignableFrom(sourceClass)) && Character.class.equals(targetClass);
    }

    @Override
    public Character convert(Object source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        if (Number.class.isInstance(source)) {
            return Character.valueOf((char)((Number)Number.class.cast(source)).intValue());
        }
        if (Boolean.class.isInstance(source)) {
            boolean b = (Boolean)Boolean.class.cast(source);
            return Character.valueOf(b ? (char)'\u0001' : '\u0000');
        }
        if (String.class.isInstance(source)) {
            return Character.valueOf(((String)String.class.cast(source)).trim().charAt(0));
        }
        throw new ConversionException("Unable to convert source to character");
    }
}

