/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToMongoTypeConverter
implements TypeConverter<Collection<?>, BasicDBList> {
    public static final String HINT_COMPARATOR_CLASS = "comparatorClass";

    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return !BasicDBList.class.isAssignableFrom(sourceClass) && Collection.class.isAssignableFrom(sourceClass) && BasicDBList.class.equals(targetClass);
    }

    @Override
    public BasicDBList convert(Collection<?> source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        BasicDBList ret = new BasicDBList();
        for (Object value : source) {
            if (value != null) {
                JavaType storageType = context.getStorageType(value.getClass());
                value = context.convert(value, storageType);
            }
            ret.add(value);
        }
        return ret;
    }
}

