/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.ReflectionUtil;
import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBList;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoToCollectionTypeConverter
implements TypeConverter<BasicDBList, Collection<?>> {
    public static final String HINT_COMPARATOR_CLASS = "comparatorClass";

    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return Collection.class.isAssignableFrom(targetClass) && BasicDBList.class.equals(sourceClass);
    }

    @Override
    public Collection<?> convert(BasicDBList source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        AbstractCollection ret;
        JavaType parameterType = null;
        Type[] types = (Type[])hints.get("genericTypeParameters");
        if (types != null && types.length > 0) {
            parameterType = JavaType.fromType(types[0]);
        }
        if (parameterType == null) {
            parameterType = targetType.getJavaTypeParameter(0);
        }
        if (parameterType == null) {
            throw new ConversionException("Unable to determine parameterType of " + targetType);
        }
        Class<?> targetClass = targetType.asClass();
        if (!targetClass.isInterface()) {
            try {
                ret = (HashSet)Collection.class.cast(ReflectionUtil.instantiate(targetClass, new Object[0]));
            }
            catch (Exception e) {
                throw new ConversionException("Couldn't instantiate " + targetClass.getName(), e);
            }
        }
        if (SortedSet.class.isAssignableFrom(targetClass)) {
            String comaparatorClassName = (String)hints.get(HINT_COMPARATOR_CLASS);
            Comparator comparator = null;
            if (comaparatorClassName != null) {
                try {
                    comparator = (Comparator)Comparator.class.cast(ReflectionUtil.instantiate(Class.forName(comaparatorClassName), new Object[0]));
                }
                catch (Exception e) {
                    throw new ConversionException("Error creating comparator: " + comaparatorClassName);
                }
            }
            ret = comparator != null ? new TreeSet(comparator) : new TreeSet();
        } else {
            ret = Set.class.isAssignableFrom(targetClass) ? new HashSet() : (List.class.isAssignableFrom(targetClass) ? new ArrayList() : new LinkedList());
        }
        for (int i = 0; i < source.size(); ++i) {
            Object value = source.get(i);
            if (value != null) {
                value = context.convert(value, parameterType);
            }
            ret.add(value);
        }
        return ret;
    }
}

