/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBObject;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoToMapTypeConverter
implements TypeConverter<BasicDBObject, Map<String, Object>> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return BasicDBObject.class.equals(sourceClass) && Map.class.isAssignableFrom(targetClass);
    }

    @Override
    public Map<String, Object> convert(BasicDBObject source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        JavaType parameterType = null;
        Type[] types = (Type[])hints.get("genericTypeParameters");
        if (types != null && types.length > 1) {
            parameterType = JavaType.fromType(types[1]);
        }
        if (parameterType == null) {
            parameterType = targetType.getJavaTypeParameter(1);
        }
        if (parameterType == null) {
            throw new ConversionException("Unable to determine parameter type for " + targetType);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value != null) {
                value = context.convert(value, parameterType);
            }
            ret.put((String)entry.getKey(), value);
        }
        return ret;
    }
}

