/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectDescriptor;
import com.googlecode.mjorm.ObjectDescriptorRegistry;
import com.googlecode.mjorm.ObjectIdValueGenerator;
import com.googlecode.mjorm.PropertyDescriptor;
import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBObject;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoToMongoTypeConverter
implements TypeConverter<Object, BasicDBObject> {
    private ObjectDescriptorRegistry registry;

    public PojoToMongoTypeConverter(ObjectDescriptorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return this.registry.hasDescriptor(sourceClass) && BasicDBObject.class.equals(targetClass);
    }

    @Override
    public BasicDBObject convert(Object source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        Class<?> sourceClass = source.getClass();
        LinkedList<ObjectDescriptor> descriptors = this.registry.getDescriptorsForType(sourceClass);
        if (descriptors.isEmpty()) {
            throw new MjormException("Unable to find ObjectDescriptor for " + sourceClass.getClass());
        }
        BasicDBObject ret = new BasicDBObject();
        for (ObjectDescriptor descriptor : descriptors) {
            for (PropertyDescriptor prop : descriptor.getProperties()) {
                try {
                    String fieldName;
                    Object value = prop.get(source);
                    if (prop.isAutoGenerated() && value == null) {
                        value = prop.getValueGenerator() != null ? prop.getValueGenerator().generate() : ObjectIdValueGenerator.INSTANCE.generate();
                        prop.set(source, context.convert(value, prop.getType()));
                    }
                    String string = fieldName = prop.isIdentifier() ? "_id" : prop.getFieldName();
                    if (value != null) {
                        JavaType storageType = prop.getStorageType();
                        if (storageType == null && value != null) {
                            storageType = context.getStorageType(value.getClass());
                        }
                        value = context.convert(value, storageType);
                    }
                    ret.put(fieldName, value);
                }
                catch (Exception e) {
                    throw new MjormException("Error mapping property " + prop.getName() + " of class " + descriptor.getType(), e);
                }
            }
        }
        return ret;
    }
}

