/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import java.lang.reflect.Type;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToUUIDConverter
implements TypeConverter<Object, UUID> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return (String.class.equals(sourceClass) || byte[].class.isAssignableFrom(sourceClass)) && UUID.class.equals(targetClass);
    }

    @Override
    public UUID convert(Object source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        if (targetType.is((Type)((Object)byte[].class)) || targetType.is((Type)((Object)Byte[].class))) {
            return UUID.nameUUIDFromBytes((byte[])byte[].class.cast(source));
        }
        return UUID.fromString((String)String.class.cast(source));
    }
}

