/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.mql;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMqlFunction {
    private String funcName = "unknown";
    private int exactArgs = -1;
    private int maxArgs = -1;
    private int minArgs = -1;
    private Class<?>[] types = new Class[0];
    private boolean initialized = false;
    private boolean strictInitialization = true;

    protected AbstractMqlFunction() {
        this.init();
        if (this.funcName == null || this.funcName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid function name");
        }
        this.initialized = true;
    }

    protected abstract void init();

    public String getName() {
        return this.funcName;
    }

    protected void assertNotInitialized() {
        if (this.strictInitialization && this.initialized) {
            throw new IllegalStateException("Function " + this.funcName + " already initialized");
        }
    }

    protected void assertArgumentTypes(Object[] arguments, Class<?> type) {
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null || type.isInstance(arguments[i])) continue;
            throw new IllegalArgumentException("Invalid type for argument " + i + " in function " + this.funcName);
        }
    }

    protected void assertArgumentTypes(Object[] arguments, Class<?>[] types) {
        if (arguments.length != types.length) {
            throw new IllegalArgumentException("Argument length doesn't match type length in function " + this.funcName);
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isInstance(arguments[i])) continue;
            throw new IllegalArgumentException("Invalid type for argument " + i + " in function " + this.funcName);
        }
    }

    protected void assertArgumentLength(Object[] arguments, int length) {
        if (arguments.length != length) {
            throw new IllegalArgumentException("Invalid argument length in function " + this.funcName);
        }
    }

    protected void assertMinimumArgumentLength(Object[] arguments, int length) {
        if (arguments.length < length) {
            throw new IllegalArgumentException("Must have at least " + length + " arguments in function " + this.funcName);
        }
    }

    protected void assertMaximumArgumentLength(Object[] arguments, int length) {
        if (arguments.length > length) {
            throw new IllegalArgumentException("Must have no more than " + length + " arguments in function " + this.funcName);
        }
    }

    protected void assertCorrectNumberOfArguments(Object[] args) {
        if (this.maxArgs != -1) {
            this.assertMaximumArgumentLength(args, this.maxArgs);
        }
        if (this.minArgs != -1) {
            this.assertMinimumArgumentLength(args, this.minArgs);
        }
        if (this.exactArgs != -1) {
            this.assertArgumentLength(args, this.exactArgs);
        }
        if (this.types.length == 1) {
            this.assertArgumentTypes(args, this.types[0]);
        }
        if (this.types.length > 1) {
            this.assertArgumentTypes(args, this.types);
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isStrictInitialization() {
        return this.strictInitialization;
    }

    protected void setStrictInitialization(boolean strictInitialization) {
        this.strictInitialization = strictInitialization;
    }

    protected String getFunctionName() {
        return this.funcName;
    }

    protected void setFunctionName(String funcName) {
        this.assertNotInitialized();
        this.funcName = funcName;
    }

    protected int getExactArgs() {
        return this.exactArgs;
    }

    protected void setExactArgs(int exactArgs) {
        this.assertNotInitialized();
        this.exactArgs = exactArgs;
    }

    protected int getMaxArgs() {
        return this.maxArgs;
    }

    protected void setMaxArgs(int maxArgs) {
        this.assertNotInitialized();
        this.maxArgs = maxArgs;
    }

    protected int getMinArgs() {
        return this.minArgs;
    }

    protected void setMinArgs(int minArgs) {
        this.assertNotInitialized();
        this.minArgs = minArgs;
    }

    protected Class<?>[] getTypes() {
        return this.types;
    }

    protected void setTypes(Class<?> ... types) {
        this.assertNotInitialized();
        this.types = types;
    }
}

