/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.mql;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.ANTLRUpperCaseInputStream;
import com.googlecode.mjorm.mql.Interpreter;
import com.googlecode.mjorm.mql.InterpreterResult;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlException;
import com.googlecode.mjorm.mql.MqlLexer;
import com.googlecode.mjorm.mql.MqlParser;
import com.googlecode.mjorm.mql.MqlVariableFunction;
import com.googlecode.mjorm.query.DaoModifier;
import com.googlecode.mjorm.query.DaoQuery;
import com.googlecode.mjorm.query.Query;
import com.googlecode.mjorm.query.QueryGroup;
import com.googlecode.mjorm.query.criteria.AbstractQueryCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.googlecode.mjorm.query.criteria.DocumentCriterion;
import com.googlecode.mjorm.query.criteria.EqualsCriterion;
import com.googlecode.mjorm.query.criteria.FieldCriterion;
import com.googlecode.mjorm.query.criteria.NotCriterion;
import com.googlecode.mjorm.query.criteria.RegexCriterion;
import com.googlecode.mjorm.query.criteria.SimpleCriterion;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterImpl
implements Interpreter {
    private static final Map<String, Object> NO_PARAMS = Collections.unmodifiableMap(new HashMap());
    private static final CommonTreeAdaptor ADAPTER = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new CommonTree(payload);
        }
    };
    private static final Map<String, SimpleCriterion.Operator> comparisonOperators = new HashMap<String, SimpleCriterion.Operator>();
    private DB db;
    private ObjectMapper objectMapper;
    private Map<String, MqlCriterionFunction> fieldFunctions;
    private Map<String, MqlCriterionFunction> documentFunctions;
    private Map<String, MqlVariableFunction> variableFunctions;

    public InterpreterImpl(DB db, ObjectMapper objectMapper) {
        this.db = db;
        this.objectMapper = objectMapper;
        this.documentFunctions = new HashMap<String, MqlCriterionFunction>();
        this.fieldFunctions = new HashMap<String, MqlCriterionFunction>();
        this.variableFunctions = new HashMap<String, MqlVariableFunction>();
    }

    public void registerFieldFunction(MqlCriterionFunction function) {
        this.fieldFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public void registerDocumentFunction(MqlCriterionFunction function) {
        this.documentFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public void registerVariableFunction(MqlVariableFunction function) {
        this.variableFunctions.put(function.getName().trim().toLowerCase(), function);
    }

    public CommonTree compile(InputStream ips) throws IOException, RecognitionException {
        MqlLexer lexer = new MqlLexer((CharStream)new ANTLRUpperCaseInputStream(ips));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MqlParser parser = new MqlParser((TokenStream)tokens);
        parser.setTreeAdaptor((TreeAdaptor)ADAPTER);
        MqlParser.start_return ast = parser.start();
        CommonTree tree = (CommonTree)CommonTree.class.cast(ast.getTree());
        this.verifyTree(tree);
        return tree;
    }

    private void verifyTree(CommonTree tree) {
        if (CommonErrorNode.class.isInstance(tree)) {
            throw new MqlException(tree);
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.verifyTree((CommonTree)CommonTree.class.cast(tree.getChild(i)));
        }
    }

    @Override
    public List<InterpreterResult> interpret(Tree tree) {
        return this.interpret(tree, NO_PARAMS);
    }

    @Override
    public List<InterpreterResult> interpret(Tree tree, Object ... parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            params.put(i + "", parameters[i]);
        }
        return this.interpret(tree, params);
    }

    @Override
    public List<InterpreterResult> interpret(Tree tree, Map<String, Object> parameters) {
        this.assertTokenType(tree, 17);
        ExecutionContext ctx = new ExecutionContext();
        ctx.params = parameters;
        ctx.currentParameterIndex = 0;
        ArrayList<InterpreterResult> ret = new ArrayList<InterpreterResult>();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            ret.add(this.doInterpret((CommonTree)CommonTree.class.cast(tree.getChild(i)), ctx));
        }
        return ret;
    }

    private InterpreterResult doInterpret(CommonTree tree, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 16);
        DaoQuery query = new DaoQuery();
        query.setDB(this.db);
        query.setObjectMapper(this.objectMapper);
        query.setCollection(this.child((Tree)tree, 0).getText());
        CommonTree actionTree = null;
        if (this.child((Tree)tree, 1).getType() == 19) {
            this.readCriteria(this.child((Tree)tree, 1), query, ctx);
            actionTree = this.child((Tree)tree, 2);
        } else {
            actionTree = this.child((Tree)tree, 1);
        }
        this.assertTokenType((Tree)actionTree, 4);
        actionTree = this.child((Tree)actionTree, 0);
        switch (actionTree.getType()) {
            case 84: {
                return this.executeSelectAction(actionTree, query, ctx);
            }
            case 35: {
                return this.executeExplainAction(actionTree, query);
            }
            case 25: {
                return this.executeDeleteAction(actionTree, query);
            }
            case 98: {
                return this.executeUpdateAction(actionTree, query, false, ctx);
            }
            case 101: {
                return this.executeUpdateAction(actionTree, query, true, ctx);
            }
            case 38: {
                return this.executeFamAction(actionTree, query, ctx);
            }
            case 36: {
                return this.executeFadAction(actionTree, query);
            }
        }
        throw new MqlException("Unknown action type");
    }

    private InterpreterResult executeFadAction(CommonTree tree, DaoQuery query) {
        CommonTree fieldListTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(40));
        DBObject fields = this.readFieldList(fieldListTree);
        CommonTree sortTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(92));
        if (sortTree != null) {
            this.readSort(sortTree, query);
        }
        return new InterpreterResult(null, query.modify().findAndDelete(fields), null);
    }

    private InterpreterResult executeFamAction(CommonTree tree, DaoQuery query, ExecutionContext ctx) {
        Tree upsert = tree.getFirstChildWithType(100);
        Tree returnTree = tree.getFirstChildWithType(79);
        boolean returnNew = returnTree != null ? returnTree.getChild(0).getType() == 65 : true;
        Tree updateTree = tree.getFirstChildWithType(99);
        this.readModifiers((CommonTree)CommonTree.class.cast(updateTree), query, ctx);
        CommonTree fieldListTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(40));
        DBObject fields = this.readFieldList(fieldListTree);
        CommonTree sortTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(92));
        if (sortTree != null) {
            this.readSort(sortTree, query);
        }
        return new InterpreterResult(null, query.modify().findAndModify(returnNew, upsert != null, fields), null);
    }

    private InterpreterResult executeUpdateAction(CommonTree tree, DaoQuery query, boolean upsert, ExecutionContext ctx) {
        Tree atomic = tree.getFirstChildWithType(11);
        Tree multi = tree.getFirstChildWithType(62);
        Tree updateTree = tree.getFirstChildWithType(99);
        this.readModifiers((CommonTree)CommonTree.class.cast(updateTree), query, ctx);
        WriteResult res = query.modify().setAtomic(atomic != null).update(upsert, multi != null);
        return new InterpreterResult(null, null, res);
    }

    private InterpreterResult executeDeleteAction(CommonTree tree, DaoQuery query) {
        Tree atomic = tree.getFirstChildWithType(11);
        WriteResult res = query.modify().setAtomic(atomic != null).delete();
        return new InterpreterResult(null, null, res);
    }

    private InterpreterResult executeExplainAction(CommonTree tree, DaoQuery query) {
        CommonTree hintTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(50));
        if (hintTree != null) {
            this.readHint(hintTree, query);
        }
        return new InterpreterResult(null, query.explain(), null);
    }

    private InterpreterResult executeSelectAction(CommonTree tree, DaoQuery query, ExecutionContext ctx) {
        CommonTree limitTree;
        CommonTree sortTree;
        CommonTree fieldListTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(40));
        DBObject fields = this.readFieldList(fieldListTree);
        CommonTree hintTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(50));
        if (hintTree != null) {
            this.readHint(hintTree, query);
        }
        if ((sortTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(92))) != null) {
            this.readSort(sortTree, query);
        }
        if ((limitTree = (CommonTree)CommonTree.class.cast(tree.getFirstChildWithType(54))) != null) {
            this.readLimit(limitTree, query, ctx);
        }
        return fields != null ? new InterpreterResult(query.findObjects(fields), null, null) : new InterpreterResult(query.findObjects(), null, null);
    }

    private void readModifiers(CommonTree tree, DaoQuery query, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 99);
        DaoModifier modifier = query.modify();
        block15: for (int i = 0; i < tree.getChildCount(); ++i) {
            CommonTree modiferTree = this.child((Tree)tree, i);
            String field = null;
            Object value = null;
            switch (modiferTree.getType()) {
                case 52: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    this.assertType(value, modiferTree, Number.class);
                    modifier.inc(field, (Number)Number.class.cast(value));
                    continue block15;
                }
                case 86: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    modifier.set(field, value);
                    continue block15;
                }
                case 96: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    modifier.unset(field);
                    continue block15;
                }
                case 74: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    modifier.push(field, value);
                    continue block15;
                }
                case 75: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    this.assertType(value, modiferTree, Object[].class);
                    modifier.pushAll(field, (Object[])Object[].class.cast(value));
                    continue block15;
                }
                case 5: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    modifier.addToSet(field, value);
                    continue block15;
                }
                case 6: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    this.assertType(value, modiferTree, Object[].class);
                    modifier.addToSetEach(field, (Object[])Object[].class.cast(value));
                    continue block15;
                }
                case 71: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    modifier.pop(field);
                    continue block15;
                }
                case 87: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    modifier.pop(field);
                    continue block15;
                }
                case 72: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    modifier.pull(field, value);
                    continue block15;
                }
                case 73: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 1), ctx);
                    this.assertType(value, modiferTree, Object[].class);
                    modifier.pullAll(field, (Object[])Object[].class.cast(value));
                    continue block15;
                }
                case 78: {
                    field = this.child((Tree)modiferTree, 0).getText();
                    value = this.child((Tree)modiferTree, 1).getText();
                    modifier.rename(field, (String)String.class.cast(value));
                    continue block15;
                }
                case 13: {
                    Tree opTree = modiferTree.getChild(0);
                    field = this.child((Tree)modiferTree, 1).getText();
                    value = this.readVariableLiteral(this.child((Tree)modiferTree, 2), ctx);
                    this.assertType(value, modiferTree, Number.class);
                    if (opTree.getType() == 8) {
                        modifier.bitwiseAnd(field, (Number)Number.class.cast(value));
                        continue block15;
                    }
                    modifier.bitwiseOr(field, (Number)Number.class.cast(value));
                    continue block15;
                }
                default: {
                    throw new MqlException("Unknown modifier:" + modiferTree.toString());
                }
            }
        }
    }

    private void readLimit(CommonTree tree, DaoQuery query, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 54);
        if (tree.getChildCount() == 1) {
            Object num = this.readVariableLiteral(this.child((Tree)tree, 0), ctx);
            this.assertType(num, tree, Number.class);
            query.setMaxDocuments(((Number)Number.class.cast(num)).intValue());
        } else {
            Object start = this.readVariableLiteral(this.child((Tree)tree, 0), ctx);
            Object num = this.readVariableLiteral(this.child((Tree)tree, 1), ctx);
            this.assertType(num, tree, Number.class);
            query.setFirstDocument(((Number)Number.class.cast(start)).intValue());
            query.setMaxDocuments(((Number)Number.class.cast(num)).intValue());
        }
    }

    private void readSort(CommonTree tree, DaoQuery query) {
        this.assertTokenType((Tree)tree, 92);
        tree = (CommonTree)CommonTree.class.cast(tree.getChild(0));
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree sortField = tree.getChild(0);
            Tree direction = tree.getChild(1);
            int dir = direction == null || direction.getType() == 10 ? 1 : -1;
            query.addSort(sortField.getText(), dir);
        }
    }

    private void readHint(CommonTree tree, DaoQuery query) {
        this.assertTokenType((Tree)tree, 50);
        if (tree.getChild(0).getType() == 63) {
            Tree direction = tree.getChild(1);
            int dir = direction == null || direction.getType() == 10 ? 1 : -1;
            query.setHint("$natural", dir);
            return;
        }
        if (this.isString(tree.getChild(0))) {
            Tree direction = tree.getChild(1);
            int dir = direction == null || direction.getType() == 10 ? 1 : -1;
            query.setHint(tree.getChild(0).getText(), dir);
            return;
        }
        BasicDBObject hint = new BasicDBObject();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree hintField = tree.getChild(0);
            Tree direction = hintField.getChild(1);
            int dir = direction == null || direction.getType() == 10 ? 1 : -1;
            hint.put(hintField.getChild(0).getText(), (Object)dir);
        }
        query.setHint((DBObject)hint);
    }

    private DBObject readFieldList(CommonTree fieldList) {
        if (fieldList == null) {
            return null;
        }
        this.assertTokenType((Tree)fieldList, 40);
        BasicDBObject fields = new BasicDBObject();
        for (int i = 0; i < fieldList.getChildCount(); ++i) {
            if (fieldList.getChild(i).getType() == 94) {
                return null;
            }
            fields.put(fieldList.getChild(i).getText(), (Object)1);
        }
        return fields;
    }

    private void readCriteria(CommonTree tree, AbstractQueryCriterion<?> query, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 19);
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.readCriterion(this.child((Tree)tree, i), query, ctx);
        }
    }

    private void readCriterion(CommonTree tree, AbstractQueryCriterion<?> query, ExecutionContext ctx) {
        DocumentCriterion criterion = null;
        String fieldName = null;
        switch (tree.getType()) {
            case 28: {
                String functionName = this.child((Tree)tree, 0).getChild(0).getText().trim().toLowerCase();
                Criterion c = this.createCriterion(tree, ctx);
                if (!DocumentCriterion.class.isInstance(c)) {
                    throw new MqlException("Document function '" + functionName + "' returned a Criterion other than a DocumentCriterion");
                }
                criterion = (DocumentCriterion)DocumentCriterion.class.cast(c);
                break;
            }
            case 39: {
                fieldName = this.child((Tree)tree, 0).getText().trim();
                criterion = new FieldCriterion(fieldName, this.createCriterion(tree, ctx));
                break;
            }
            case 18: {
                fieldName = this.child((Tree)tree, 0).getText().trim();
                criterion = new FieldCriterion(fieldName, this.createCriterion(tree, ctx));
                break;
            }
            case 64: {
                fieldName = this.child((Tree)tree, 0).getChild(0).getText().trim();
                criterion = new NotCriterion(fieldName, this.createCriterion(this.child((Tree)tree, 0), ctx));
                break;
            }
            default: {
                this.assertTokenType((Tree)tree, new int[0]);
            }
        }
        query.add(criterion);
    }

    private Criterion createCriterion(CommonTree tree, ExecutionContext ctx) {
        switch (tree.getType()) {
            case 28: {
                return this.readCriterionForFunctionCall(this.child((Tree)tree, 0), this.documentFunctions, ctx);
            }
            case 39: {
                return this.readCriterionForFunctionCall(this.child((Tree)tree, 1), this.fieldFunctions, ctx);
            }
            case 18: {
                String op = this.child((Tree)tree, 1).getText();
                Object value = this.readVariableLiteral(this.child((Tree)tree, 2), ctx);
                if (op.equals("=")) {
                    return new EqualsCriterion(value);
                }
                if (op.equals("=~")) {
                    this.assertType(value, tree, Pattern.class);
                    return new RegexCriterion((Pattern)Pattern.class.cast(value));
                }
                return new SimpleCriterion(comparisonOperators.get(op), value);
            }
            case 64: {
                Criterion c = this.createCriterion(this.child((Tree)tree, 0), ctx);
                if (!FieldCriterion.class.isInstance(c)) {
                    throw new MqlException("NOT requires FieldCriteiron");
                }
                return new NotCriterion((FieldCriterion)FieldCriterion.class.cast(c));
            }
        }
        this.assertTokenType((Tree)tree, new int[0]);
        return null;
    }

    private Criterion readCriterionForFunctionCall(CommonTree tree, Map<String, MqlCriterionFunction> functionTable, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 45);
        String functionName = this.child((Tree)tree, 0).getText().trim().toLowerCase();
        Criterion ret = null;
        if (!functionTable.containsKey(functionName)) {
            throw new MqlException("Unknown function: " + functionName);
        }
        if (tree.getChildCount() == 1) {
            ret = functionTable.get(functionName).createForNoArguments();
        } else if (this.child((Tree)tree, 1).getType() == 19) {
            Query query = new Query();
            this.readCriteria(this.child((Tree)tree, 1), query, ctx);
            ret = functionTable.get(functionName).createForQuery(query);
        } else if (this.child((Tree)tree, 1).getType() == 21) {
            QueryGroup queryGroup = new QueryGroup();
            this.readCriteriaGroupList(this.child((Tree)tree, 1), queryGroup, ctx);
            ret = functionTable.get(functionName).createForQueryGroup(queryGroup);
        } else if (this.child((Tree)tree, 1).getType() == 102) {
            Object[] arguments = this.readVariableList(this.child((Tree)tree, 1), ctx);
            ret = functionTable.get(functionName).createForArguments(arguments);
        }
        return ret;
    }

    private QueryGroup readCriteriaGroupList(CommonTree tree, QueryGroup queryGroup, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 21);
        if (queryGroup == null) {
            queryGroup = new QueryGroup();
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            CommonTree groupCommonTree = this.child((Tree)tree, i);
            Query query = new Query();
            this.readCriteria(this.child((Tree)groupCommonTree, 0), query, ctx);
            queryGroup.add(query);
        }
        return queryGroup;
    }

    private Object readVariableLiteral(CommonTree tree, ExecutionContext ctx) {
        String text = tree.getText();
        switch (tree.getType()) {
            case 45: {
                String functionName = this.child((Tree)tree, 0).getText().trim().toLowerCase();
                if (!this.variableFunctions.containsKey(functionName)) {
                    throw new MqlException("Unknown function: " + functionName);
                }
                Object[] args = tree.getChildCount() > 1 ? this.readVariableList(this.child((Tree)tree, 1), ctx) : new Object[]{};
                return this.variableFunctions.get(functionName).invoke(args);
            }
            case 70: {
                String name = this.child((Tree)tree, 0).getText();
                return ctx.getParameter(name, tree);
            }
            case 77: {
                return Pattern.compile(text.substring(1, text.length() - 1));
            }
            case 53: {
                return new Integer(text);
            }
            case 23: {
                return new Double(text);
            }
            case 30: {
                return this.evaluateString(text);
            }
            case 90: {
                return this.evaluateString(text);
            }
            case 95: {
                return Boolean.TRUE;
            }
            case 37: {
                return Boolean.FALSE;
            }
            case 9: {
                Object[] vars = new Object[this.child((Tree)tree, 0).getChildCount()];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = this.readVariableLiteral(this.child((Tree)this.child((Tree)tree, 0), i), ctx);
                }
                return vars;
            }
        }
        throw new MqlException("Unknown variable literal type " + tree.getType() + " with value " + text);
    }

    private String evaluateString(String text) {
        text = text.substring(1, text.length() - 1);
        int s = 0;
        while (s < text.length()) {
            int idx = -1;
            idx = text.indexOf("\\n", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\n" + text.substring(idx + 2);
                s = idx + "\n".length();
                continue;
            }
            idx = text.indexOf("\\r", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\r" + text.substring(idx + 2);
                s = idx + "\r".length();
                continue;
            }
            idx = text.indexOf("\\t", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\t" + text.substring(idx + 2);
                s = idx + "\t".length();
                continue;
            }
            idx = text.indexOf("\\b", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\b" + text.substring(idx + 2);
                s = idx + "\b".length();
                continue;
            }
            idx = text.indexOf("\\f", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\f" + text.substring(idx + 2);
                s = idx + "\f".length();
                continue;
            }
            idx = text.indexOf("\\\"", s);
            if (idx != -1) {
                text = text.substring(0, idx) + "\"" + text.substring(idx + 2);
                s = idx + "\"".length();
                continue;
            }
            idx = text.indexOf("\\'", s);
            if (idx == -1) break;
            text = text.substring(0, idx) + "'" + text.substring(idx + 2);
            s = idx + "'".length();
        }
        return text;
    }

    private Object[] readVariableList(CommonTree tree, ExecutionContext ctx) {
        this.assertTokenType((Tree)tree, 102);
        Object[] ret = new Object[tree.getChildCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.readVariableLiteral(this.child((Tree)tree, i), ctx);
        }
        return ret;
    }

    private void assertTokenType(Tree tree, int ... types) {
        if (tree == null) {
            throw new MqlException("Got a null token when expecting a specific type");
        }
        int treeType = tree.getType();
        for (int type : types) {
            if (type != treeType) continue;
            return;
        }
        throw new MqlException("Unknown token: " + tree.toString());
    }

    private CommonTree child(Tree tree, int idx) {
        return (CommonTree)CommonTree.class.cast(tree.getChild(idx));
    }

    private boolean isString(Tree tree) {
        return tree != null && (tree.getType() == 30 || tree.getType() == 90);
    }

    private void assertType(Object value, CommonTree tree, Class<?> ... types) {
        if (value == null) {
            return;
        }
        for (Class<?> type : types) {
            if (!type.isInstance(value)) continue;
            return;
        }
        throw new MqlException(tree, "Unexpected variable type");
    }

    static /* synthetic */ Map access$400() {
        return NO_PARAMS;
    }

    static {
        comparisonOperators.put(">", SimpleCriterion.Operator.GT);
        comparisonOperators.put(">=", SimpleCriterion.Operator.GTE);
        comparisonOperators.put("<", SimpleCriterion.Operator.LT);
        comparisonOperators.put("<=", SimpleCriterion.Operator.LTE);
        comparisonOperators.put("!=", SimpleCriterion.Operator.NE);
        comparisonOperators.put("<>", SimpleCriterion.Operator.NE);
    }

    private class ExecutionContext {
        private Map<String, Object> params = InterpreterImpl.access$400();
        private int currentParameterIndex = 0;

        private ExecutionContext() {
        }

        private Object getParameter(String name, CommonTree tree) {
            if (name.equals("?")) {
                name = this.currentParameterIndex + "";
                ++this.currentParameterIndex;
            }
            if (!this.params.containsKey(name)) {
                throw new MqlException(tree, "Parameter " + name + " was not found");
            }
            return this.params.get(name);
        }
    }
}

