/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.mql;

import com.googlecode.mjorm.ObjectIterator;
import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.Interpreter;
import com.googlecode.mjorm.mql.InterpreterFactory;
import com.googlecode.mjorm.mql.InterpreterResult;
import com.googlecode.mjorm.mql.MqlException;
import com.googlecode.mjorm.mql.Statement;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementImpl
implements Statement {
    private static final Logger LOGGER = Logger.getLogger(StatementImpl.class.getName());
    private Tree tree;
    private Map<String, Object> parameters;
    private Interpreter interpreter;
    private ObjectMapper objectMapper;

    public StatementImpl(InputStream mql, DB db, ObjectMapper objectMapper) throws IOException, RecognitionException {
        try {
            this.interpreter = InterpreterFactory.getDefaultInstance().create(db, objectMapper);
            this.tree = this.interpreter.compile(mql);
        }
        catch (Exception e) {
            throw new MqlException(e);
        }
        this.parameters = new HashMap<String, Object>();
        this.objectMapper = objectMapper;
    }

    @Override
    public Statement setParameters(Map<String, Object> params) {
        this.parameters.clear();
        this.parameters.putAll(params);
        return this;
    }

    @Override
    public Statement setParameters(Object ... params) {
        this.parameters.clear();
        for (int i = 0; i < params.length; ++i) {
            this.parameters.put(i + "", params[i]);
        }
        return this;
    }

    @Override
    public Statement setParameter(String name, Object param) {
        this.parameters.put(name, param);
        return this;
    }

    @Override
    public Statement setParameter(int index, Object param) {
        this.parameters.put(index + "", param);
        return this;
    }

    @Override
    public Statement clearParameters() {
        this.parameters.clear();
        return this;
    }

    @Override
    public DBCursor execute() {
        InterpreterResult res = this.executeInternal();
        if (res.getCursor() == null) {
            throw new MqlException("Expected a DBCursor and din't get one");
        }
        return res.getCursor();
    }

    @Override
    public DBObject executeSingle() {
        InterpreterResult res = this.executeInternal();
        if (res.getObject() != null) {
            return res.getObject();
        }
        if (res.getCursor() != null) {
            DBCursor cursor = res.getCursor();
            DBObject ret = cursor.hasNext() ? cursor.next() : null;
            cursor.close();
            return ret;
        }
        throw new MqlException("Expected a DBCursor or DBObject and din't get one");
    }

    @Override
    public <T> ObjectIterator<T> execute(Class<T> clazz) {
        return new ObjectIterator<T>(this.execute(), this.objectMapper, clazz);
    }

    @Override
    public <T> T executeSingle(Class<T> clazz) {
        return this.objectMapper.map(this.executeSingle(), clazz);
    }

    @Override
    public void executeUpdate() {
        this.executeInternal();
    }

    private InterpreterResult executeInternal() {
        List<InterpreterResult> res = this.interpreter.interpret(this.tree, this.parameters);
        if (res.isEmpty()) {
            throw new MqlException("No InterpreterResult was returned");
        }
        if (res.size() > 1) {
            LOGGER.warning("interpretation returned more than one InterpreterResult, using the last");
        }
        return res.get(res.size() - 1);
    }
}

