/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query;

import com.googlecode.mjorm.query.DaoQuery;
import com.googlecode.mjorm.query.modifiers.AbstractQueryModifiers;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoModifier
extends AbstractQueryModifiers<DaoModifier> {
    private DaoQuery query;
    private boolean atomic = false;
    private WriteConcern writeConcern = null;
    private DBEncoder dbEncoder = null;

    public DaoModifier() {
        this.clear();
    }

    public DaoModifier(DaoQuery query) {
        this.query = query;
        this.clear();
    }

    public void assertValid() {
        if (this.query == null) {
            throw new IllegalStateException("query must be specified");
        }
        this.query.assertValid();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    protected DaoModifier self() {
        return this;
    }

    public DaoQuery getQuery() {
        return this.query;
    }

    public DaoModifier setQuery(DaoQuery query) {
        this.query = query;
        return this.self();
    }

    public DaoModifier setAtomic(boolean atomic) {
        this.atomic = atomic;
        return this.self();
    }

    public DaoModifier setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this.self();
    }

    public DaoModifier setDBEncoder(DBEncoder dbEncoder) {
        this.dbEncoder = dbEncoder;
        return this.self();
    }

    public WriteResult delete() {
        this.assertValid();
        DBCollection collection = this.query.getDB().getCollection(this.query.getCollection());
        WriteConcern concern = this.writeConcern;
        if (concern == null) {
            concern = collection.getWriteConcern();
        }
        return this.query.getDB().getCollection(this.query.getCollection()).remove(this.query.toQueryObject(this.query.getObjectMapper()), concern, this.dbEncoder);
    }

    public <T> T findAndDelete(Class<T> clazz) {
        this.assertValid();
        DBObject object = this.query.getDB().getCollection(this.query.getCollection()).findAndModify(this.query.toQueryObject(this.query.getObjectMapper()), null, this.query.getSortDBObject(), true, null, false, false);
        return this.query.getObjectMapper().map(object, clazz);
    }

    public DBObject findAndDelete(DBObject fields) {
        this.assertValid();
        return this.query.getDB().getCollection(this.query.getCollection()).findAndModify(this.query.toQueryObject(this.query.getObjectMapper()), fields, this.query.getSortDBObject(), true, null, false, false);
    }

    public DBObject findAndDelete() {
        this.assertValid();
        return this.findAndDelete((DBObject)null);
    }

    public <T> T findAndModify(boolean returnNew, boolean upsert, Class<T> clazz) {
        this.assertValid();
        DBObject object = this.query.getDB().getCollection(this.query.getCollection()).findAndModify(this.query.toQueryObject(this.query.getObjectMapper()), null, this.query.getSortDBObject(), false, this.toModifierObject(), returnNew, upsert);
        return this.query.getObjectMapper().map(object, clazz);
    }

    public DBObject findAndModify(boolean returnNew, boolean upsert, DBObject fields) {
        this.assertValid();
        return this.query.getDB().getCollection(this.query.getCollection()).findAndModify(this.query.toQueryObject(this.query.getObjectMapper()), fields, this.query.getSortDBObject(), false, this.toModifierObject(), returnNew, upsert);
    }

    public DBObject findAndModify(boolean returnNew, boolean upsert) {
        this.assertValid();
        return this.findAndModify(returnNew, upsert, (DBObject)null);
    }

    public WriteResult update(boolean upsert, boolean multi) {
        WriteResult result;
        this.assertValid();
        DBCollection collection = this.query.getDB().getCollection(this.query.getCollection());
        WriteConcern concern = this.writeConcern;
        if (concern == null) {
            concern = collection.getWriteConcern();
        }
        DBObject criteria = this.query.toQueryObject(this.query.getObjectMapper());
        if (this.atomic) {
            criteria.put("$atomic", (Object)1);
        }
        if ((result = collection.update(criteria, this.toModifierObject(), upsert, multi, concern, this.dbEncoder)).getError() != null) {
            throw new MongoException(result.getError());
        }
        return result;
    }

    public WriteResult update() {
        return this.update(false, false);
    }

    public WriteResult updateMulti() {
        return this.update(false, true);
    }

    public WriteResult upsert() {
        return this.update(true, false);
    }

    public WriteResult upsertMulti() {
        return this.update(true, true);
    }

    @Override
    public DBObject toModifierObject() {
        return super.toModifierObject();
    }
}

