/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.DBObjectUtil;
import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.googlecode.mjorm.query.criteria.DocumentCriterion;
import com.googlecode.mjorm.query.criteria.FieldCriterion;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCriterionBuilder<T extends AbstractCriterionBuilder<T>>
extends AbstractCriterion {
    protected Stack<String> propertyStack = new Stack();
    protected List<DocumentCriterion> criteria = new ArrayList<DocumentCriterion>();

    protected abstract T self();

    public void clear() {
        this.criteria.clear();
        this.propertyStack.clear();
    }

    public T push(String property) {
        this.propertyStack.push(property);
        return this.self();
    }

    public T pop() {
        this.propertyStack.pop();
        return this.self();
    }

    public T add(String property, Criterion criterion) {
        FieldCriterion fc = new FieldCriterion(property, criterion);
        for (int i = this.propertyStack.size() - 1; i >= 0; --i) {
            fc = new FieldCriterion((String)this.propertyStack.get(i), fc);
        }
        this.add(fc);
        return this.self();
    }

    public T add(DocumentCriterion criterion) {
        this.criteria.add(criterion);
        return this.self();
    }

    public DBObject toQueryObject(ObjectMapper mapper) {
        BasicDBObject ret = new BasicDBObject();
        for (DocumentCriterion criterion : this.criteria) {
            DBObjectUtil.merge(criterion.toQueryObject(mapper), (DBObject)ret);
        }
        return ret;
    }
}

