/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.criteria;

import com.googlecode.mjorm.ObjectMapper;
import com.googlecode.mjorm.mql.AbstractMqlCriterionFunction;
import com.googlecode.mjorm.mql.MqlCriterionFunction;
import com.googlecode.mjorm.query.criteria.AbstractCriterion;
import com.googlecode.mjorm.query.criteria.Criterion;
import com.mongodb.BasicDBObject;

public class WithinPolygonCriterion
extends AbstractCriterion {
    private Number[][] points;

    public WithinPolygonCriterion(Number[][] points) {
        this.points = points;
    }

    public Number[][] getPoints() {
        return this.points;
    }

    public Object toQueryObject(ObjectMapper mapper) {
        return new BasicDBObject("$within", (Object)new BasicDBObject("$polygon", (Object)this.points));
    }

    public static MqlCriterionFunction createFunction(final String functionName) {
        return new AbstractMqlCriterionFunction(){

            protected void init() {
                this.setFunctionName(functionName);
                this.setMinArgs(1);
                this.setMaxArgs(Integer.MAX_VALUE);
                this.setTypes(Object[].class);
            }

            protected Criterion doCreate(Object[] values) {
                Number[][] points = new Number[values.length][];
                for (int i = 0; i < values.length; ++i) {
                    Object[] realValues = (Object[])Object[].class.cast(values[i]);
                    points[i] = new Number[2];
                    points[i][0] = (Number)Number.class.cast(realValues[0]);
                    points[i][1] = (Number)Number.class.cast(realValues[1]);
                }
                return new WithinPolygonCriterion(points);
            }
        };
    }
}

